import 'package:fl_ks_smart_society_user/localization/localization.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

String tr(BuildContext context, String key) {
  return DemoLocalizations.of(context).getTranslation(key);
}

String translate(String key) {
  return DemoLocalizations.instance.getTranslation(key);
}

const String english = 'en';
const String hindi = 'hi';
const String tamil = 'ta';
const String telugu = 'te';

const String languageKey = 'languageCode';

int? languageValue;

Future setIntLanguageValue(int languageValue) async {
  SharedPreferences preferences = await SharedPreferences.getInstance();

  await preferences.setInt('value', languageValue);
}

Future getIntLanguageValue() async {
  SharedPreferences preferences = await SharedPreferences.getInstance();
  languageValue = preferences.getInt('value') ?? 0;
}

Future setLocale(String languageCode) async {
  SharedPreferences preferences = await SharedPreferences.getInstance();

  await preferences.setString(languageKey, languageCode);
  return _locale(languageCode);
}

Future getLocale() async {
  SharedPreferences preferences = await SharedPreferences.getInstance();
  String languageCode = preferences.getString(languageKey) ?? english;
  return _locale(languageCode);
}

Locale _locale(languageCode) {
  Locale temp;
  switch (languageCode) {
    case english:
      temp = Locale(languageCode);
      break;
    case hindi:
      temp = Locale(languageCode);
      break;
    case tamil:
      temp = Locale(languageCode);
      break;
    case telugu:
      temp = Locale(languageCode);
      break;
    default:
      temp = const Locale(english);
  }

  return temp;
}
