import 'package:fl_ks_smart_society_user/localization/localization.dart';
import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:page_transition/page_transition.dart';
import 'package:fl_ks_smart_society_user/screens/screens.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  static void setLocale(BuildContext content, Locale locale) {
    _MyAppState state = content.findAncestorStateOfType<_MyAppState>()!;
    state.setLocale(locale);
  }

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  Locale? _locale;

  void setLocale(Locale locale) {
    setState(() {
      _locale = locale;
    });
  }

  @override
  void didChangeDependencies() {
    getLocale().then((locale) {
      setState(() {
        _locale = locale;
      });
    });
    getIntLanguageValue();
    super.didChangeDependencies();
  }

  // This widget is the root of your application.
  @override
  Widget build(BuildContext context) {
    return AnnotatedRegion(
      value: const SystemUiOverlayStyle(
        statusBarColor: primaryColor,
        statusBarIconBrightness: Brightness.light,
      ),
      child: MaterialApp(
        debugShowCheckedModeBanner: false,
        title: 'Gelite',
        theme: ThemeData(
          colorScheme: ColorScheme.fromSeed(
            seedColor: primaryColor,
            primary: primaryColor,
          ),
          useMaterial3: true,
          fontFamily: 'Rubik',
          scaffoldBackgroundColor: screenBgColor,
          primaryColor: primaryColor,
          appBarTheme: AppBarTheme(
            surfaceTintColor: Colors.transparent,
            systemOverlayStyle: const SystemUiOverlayStyle(
              statusBarColor: primaryColor,
              statusBarIconBrightness: Brightness.light,
            ),
            elevation: 6.0,
            shadowColor: originalBlackColor.withOpacity(0.25),
          ),
          bottomSheetTheme: const BottomSheetThemeData(
            surfaceTintColor: Colors.transparent,
          ),
          timePickerTheme: timePickerTheme(),
          inputDecorationTheme: InputDecorationTheme(
            prefixIconColor: WidgetStateColor.resolveWith(
              (states) => states.contains(WidgetState.focused)
                  ? primaryColor
                  : greyColor,
            ),
          ),
        ),
        home: const SplashScreen(),
        onGenerateRoute: routes,
        locale: _locale,
        supportedLocales: const [
          Locale('en'),
          Locale('hi'),
          Locale('ta'), // Tamil
          Locale('te'), // Telugu

        ],
        localizationsDelegates: [
          DemoLocalizations.delegate,
          GlobalCupertinoLocalizations.delegate,
          GlobalMaterialLocalizations.delegate,
          GlobalWidgetsLocalizations.delegate,
        ],
        localeResolutionCallback: (deviceLocale, supportedLocale) {
          for (var locale in supportedLocale) {
            if (locale.languageCode != deviceLocale!.languageCode) {
              return deviceLocale;
            }
          }
          return supportedLocale.first;
        },
      ),
    );
  }

  Route<dynamic>? routes(settings) {
    switch (settings.name) {
      case '/':
        return PageTransition(
          child: const SplashScreen(),
          type: PageTransitionType.fade,
          settings: settings,
        );
      case '/onboarding':
        return PageTransition(
          child: const OnboardingScreen(),
          type: PageTransitionType.fade,
          settings: settings,
        );
      case '/login':
        return PageTransition(
          child: const LoginScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/register':
        return PageTransition(
          child: const RegisterScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/otp':
        return PageTransition(
          child: const OTPScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/addAddress':
        return PageTransition(
          child: const AddAddressScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/bottombar':
        return PageTransition(
          child: const BottomBar(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/home':
        return PageTransition(
          child: const HomeScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/notification':
        return PageTransition(
          child: const NotificationScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/addGuest':
        return PageTransition(
          child: const AddGuestScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/addCab':
        return PageTransition(
          child: const AddCabScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/addDelivery':
        return PageTransition(
          child: const AddDeliveryScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/addServices':
        return PageTransition(
          child: const AddServicesScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/members':
        return PageTransition(
          child: const MembersScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/call':
        return PageTransition(
          child: const CallScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/chat':
        return PageTransition(
          child: const ChatScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/visitors':
        return PageTransition(
          child: const VisitorsScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/gatePass':
        return PageTransition(
          child: const GatePassScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/noticeBoard':
        return PageTransition(
          child: const NoticeBoardScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/societyPayment':
        return PageTransition(
          child: const SocietyPaymentScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/paymentSuccess':
        return PageTransition(
          child: const PaymentSuccessScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/selectPayment':
        return PageTransition(
          child: const SelectPaymentScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/creditcard':
        return PageTransition(
          child: const CreditCardScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/bookAmenities':
        return PageTransition(
          child: const BookAmenitiesScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/selectAmenities':
        return PageTransition(
          child: const SelectAmenitiesScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/bookAmenitiesDetail':
        return PageTransition(
          child: const BookAmenitiesDetailScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/helpDesk':
        return PageTransition(
          child: const HelpDeskScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/complaintDetail':
        return PageTransition(
          child: const ComplaintDetailScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/raisedNewComplaint':
        return PageTransition(
          child: const RaisedNewComplaintScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/security':
        return PageTransition(
          child: const SecurityScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/events':
        return PageTransition(
          child: const EventsScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/messages':
        return PageTransition(
          child: const MessagesScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/service':
        return PageTransition(
          child: const ServiceScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/bookService':
        return PageTransition(
          child: const BookServiceScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/profile':
        return PageTransition(
          child: const ProfileScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/editAddress':
        return PageTransition(
          child: const EditAddresScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/editProfile':
        return PageTransition(
          child: const EditProfileScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/language':
        return PageTransition(
          child: const LanguageScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/termsAndCondition':
        return PageTransition(
          child: const TermsAndConditionScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/privacyPolicy':
        return PageTransition(
          child: const PrivacyPolicyScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );

      case '/memberDetails':
        return PageTransition(
          child: const MemberDetailsScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/birthday':
        return PageTransition(
          child: const BirthdayScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/wedding':
        return PageTransition(
          child: const CelebrationScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      case '/helpAndSupport':
        return PageTransition(
          child: const HelpAndSupportScreen(),
          type: PageTransitionType.rightToLeft,
          settings: settings,
        );
      default:
        return null;
    }
  }


  TimePickerThemeData timePickerTheme() {
    return TimePickerThemeData(
      backgroundColor: whiteColor,
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.circular(10.0),
      ),
      hourMinuteColor: primaryColor,
      hourMinuteTextStyle: regular45White,
      hourMinuteTextColor: whiteColor,
      dayPeriodColor: primaryColor,
      dayPeriodTextStyle: WidgetStateTextStyle.resolveWith(
        (states) => states.contains(WidgetState.focused)
            ? regular16White
            : regular16Black,
      ),
      dayPeriodBorderSide: const BorderSide(
        color: primaryColor,
      ),
      cancelButtonStyle: const ButtonStyle(
        foregroundColor: WidgetStatePropertyAll(greyColor),
        textStyle: WidgetStatePropertyAll(
          medium16Grey,
        ),
      ),
      confirmButtonStyle: const ButtonStyle(
        foregroundColor: WidgetStatePropertyAll(primaryColor),
        textStyle: WidgetStatePropertyAll(medium16Primary),
      ),
    );
  }
}
