import 'dart:async';

import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class AddAddressScreen extends StatefulWidget {
  const AddAddressScreen({super.key});

  @override
  State<AddAddressScreen> createState() => _AddAddressScreenState();
}

class _AddAddressScreenState extends State<AddAddressScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'add_address.address'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.all(fixPadding * 2.0),
        children: [
          addAddressContent(),
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          societyNameField(),
          heightSpace,
          heightSpace,
          heightSpace,
          buildingField(),
          heightSpace,
          heightSpace,
          heightSpace,
          flatNumberField(),
        ],
      ),
      bottomNavigationBar: continueButton(context),
    );
  }

  continueButton(BuildContext context) {
    return Padding(
      padding: EdgeInsets.only(bottom: MediaQuery.viewInsetsOf(context).bottom),
      child: GestureDetector(
        onTap: () {
          Timer(const Duration(seconds: 3), () {
            Navigator.popAndPushNamed(context, '/bottombar');
          });
          pleaseWaitDialog(context);
        },
        child: Container(
          margin: const EdgeInsets.symmetric(
              vertical: fixPadding * 2.5, horizontal: fixPadding * 2.0),
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
          decoration: BoxDecoration(
            color: primaryColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: buttonShadow,
          ),
          child: Text(
            tr(context, 'add_address.continue'),
            style: medium20White,
            overflow: TextOverflow.ellipsis,
            textAlign: TextAlign.center,
          ),
        ),
      ),
    );
  }

  Future<dynamic> pleaseWaitDialog(BuildContext context) {
    return showDialog(
      barrierDismissible: false,
      context: context,
      builder: (context) {
        return Dialog(
          backgroundColor: whiteColor,
          insetPadding: const EdgeInsets.all(fixPadding * 2.0),
          shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.circular(10.0),
          ),
          child: ListView(
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
            padding: const EdgeInsets.symmetric(
                horizontal: fixPadding * 2.0, vertical: fixPadding * 3.5),
            children: [
              const CupertinoActivityIndicator(
                color: primaryColor,
                radius: 16.0,
              ),
              heightSpace,
              Text(
                tr(context, 'add_address.please_wait'),
                style: medium18Primary,
                textAlign: TextAlign.center,
              )
            ],
          ),
        );
      },
    );
  }

  flatNumberField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'add_address.flat_number')),
        heightSpace,
        Container(
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            style: regular15Black,
            cursorColor: primaryColor,
            keyboardType: TextInputType.number,
            decoration: InputDecoration(
              border: InputBorder.none,
              isDense: true,
              focusedBorder: focusedBorder,
              hintText: tr(context, 'add_address.enter_flat_number'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.4, horizontal: fixPadding * 1.5),
            ),
          ),
        )
      ],
    );
  }

  buildingField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'add_address.building')),
        heightSpace,
        Container(
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            style: regular15Black,
            cursorColor: primaryColor,
            decoration: InputDecoration(
              border: InputBorder.none,
              isDense: true,
              focusedBorder: focusedBorder,
              hintText: tr(context, 'add_address.enter_bulilding_number'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.4, horizontal: fixPadding * 1.5),
            ),
          ),
        )
      ],
    );
  }

  societyNameField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'add_address.society_name')),
        heightSpace,
        Container(
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            style: regular15Black,
            cursorColor: primaryColor,
            keyboardType: TextInputType.name,
            decoration: InputDecoration(
              border: InputBorder.none,
              isDense: true,
              focusedBorder: focusedBorder,
              hintText: tr(context, 'add_address.enter_society_name'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.4, horizontal: fixPadding * 1.5),
            ),
          ),
        )
      ],
    );
  }

  title(String title) {
    return Text(
      title,
      style: regular16Black,
    );
  }

  addAddressContent() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        Text(
          tr(context, 'add_address.add_address'),
          style: regular18Black,
        ),
        heightSpace,
        Text(
          tr(context, 'add_address.add_content'),
          style: regular16Grey,
          textAlign: TextAlign.center,
        )
      ],
    );
  }
}
