import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class AddCabScreen extends StatefulWidget {
  const AddCabScreen({super.key});

  @override
  State<AddCabScreen> createState() => _AddCabScreenState();
}

class _AddCabScreenState extends State<AddCabScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
      ),
      body: ListView(
        padding: const EdgeInsets.fromLTRB(fixPadding * 2.0, fixPadding * 3.0,
            fixPadding * 2.0, fixPadding * 2.0),
        physics: const BouncingScrollPhysics(),
        children: [
          logoAndContent(),
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          cabNumberField(),
          heightSpace,
          heightSpace,
          height5Space,
          companyNameField(),
        ],
      ),
      bottomNavigationBar: submitButton(context),
    );
  }

  Widget submitButton(BuildContext context) {
    return Padding(
      padding: EdgeInsets.only(
        bottom: MediaQuery.viewInsetsOf(context).bottom,
      ),
      child: GestureDetector(
        onTap: () {
          Navigator.pop(context);
        },
        child: Container(
          width: double.maxFinite,
          margin: const EdgeInsets.symmetric(
              vertical: fixPadding * 2.5, horizontal: fixPadding * 2.0),
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
          decoration: BoxDecoration(
            color: primaryColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: buttonShadow,
          ),
          child: Text(
            tr(context, 'add_cab.submit'),
            style: medium20White,
            textAlign: TextAlign.center,
            overflow: TextOverflow.ellipsis,
          ),
        ),
      ),
    );
  }

  Widget companyNameField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          tr(context, 'add_cab.company_name'),
          style: regular16Black,
        ),
        heightSpace,
        Container(
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            cursorColor: primaryColor,
            keyboardType: TextInputType.name,
            style: regular15Black,
            decoration: InputDecoration(
              border: InputBorder.none,
              focusedBorder: focusedBorder,
              isDense: true,
              hintText: tr(context, 'add_cab.enter_cab_company_name'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.4, horizontal: fixPadding * 1.5),
            ),
          ),
        )
      ],
    );
  }

  Widget cabNumberField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          tr(context, 'add_cab.last_digit_cab_num'),
          style: regular16Black,
        ),
        heightSpace,
        Container(
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            cursorColor: primaryColor,
            keyboardType: TextInputType.number,
            inputFormatters: [
              FilteringTextInputFormatter.digitsOnly,
              LengthLimitingTextInputFormatter(4)
            ],
            style: regular15Black,
            decoration: InputDecoration(
              border: InputBorder.none,
              focusedBorder: focusedBorder,
              isDense: true,
              hintText: tr(context, 'add_cab.enter_cab_number'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.4, horizontal: fixPadding * 1.5),
            ),
          ),
        )
      ],
    );
  }

  Widget logoAndContent() {
    return Column(
      children: [
        Container(
          height: 100.0,
          width: 100.0,
          decoration: const BoxDecoration(
            shape: BoxShape.circle,
            color: primaryColor,
          ),
          alignment: Alignment.center,
          child: Image.asset(
            "assets/icons/vehicle-cab.png",
            height: 50.0,
            fit: BoxFit.contain,
          ),
        ),
        height5Space,
        Text(
          tr(context, 'add_cab.allow_my_cab'),
          style: medium17Primary,
          textAlign: TextAlign.center,
        ),
      ],
    );
  }
}
