import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/column_builder.dart';
import 'package:flutter/material.dart';

class BookAmenitiesScreen extends StatefulWidget {
  const BookAmenitiesScreen({super.key});

  @override
  State<BookAmenitiesScreen> createState() => _BookAmenitiesScreenState();
}

class _BookAmenitiesScreenState extends State<BookAmenitiesScreen> {
  final amenitiesList = [
    {
      "title": "Community hall",
      "confirmBy": "preety shah",
      "fromToDate": "20 march 2023-23 march 2023",
      "time": "12:00 AM to 11:59 PM",
      "status": "Confirmed",
      "price": "\$60.00",
      "isPaid": true,
    },
    {
      "title": "Club house",
      "confirmBy": "preety shah",
      "fromToDate": "20 Aug 2023-23 Aug 2023",
      "time": "01:00 AM to 11:00 PM",
      "status": "Pending",
      "price": "\$60.00",
      "isPaid": false,
    },
    {
      "title": "Community hall",
      "confirmBy": "preety shah",
      "fromToDate": "25 April  2023-28 April 2023",
      "time": "01:00 AM to 11:00 PM",
      "status": "Confirmed",
      "price": "\$60.00",
      "isPaid": true,
    },
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'book_amenities.book_amenities'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.only(bottom: fixPadding),
        children: [
          topImage(),
          heightSpace,
          amenitiesListContent(),
        ],
      ),
      bottomNavigationBar: bookAmenitiesButton(),
    );
  }

  bookAmenitiesButton() {
    return GestureDetector(
      onTap: () {
        Navigator.pushNamed(context, '/selectAmenities');
      },
      child: Container(
        padding: const EdgeInsets.symmetric(
            vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
        margin: const EdgeInsets.symmetric(
            vertical: fixPadding * 2.5, horizontal: fixPadding * 2.0),
        decoration: BoxDecoration(
          color: primaryColor,
          borderRadius: BorderRadius.circular(10.0),
          boxShadow: buttonShadow,
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            const Icon(
              Icons.add,
              color: whiteColor,
            ),
            width5Space,
            ConstrainedBox(
              constraints: BoxConstraints(
                  maxWidth: MediaQuery.sizeOf(context).width - 110),
              child: Text(
                tr(context, 'book_amenities.book_amenity'),
                style: medium20White,
                textAlign: TextAlign.center,
                overflow: TextOverflow.ellipsis,
              ),
            ),
          ],
        ),
      ),
    );
  }

  amenitiesListContent() {
    return ColumnBuilder(
      itemBuilder: (context, index) {
        final itemData = amenitiesList[index];
        return Container(
          margin: const EdgeInsets.symmetric(vertical: fixPadding),
          padding: const EdgeInsets.only(bottom: fixPadding),
          width: double.maxFinite,
          decoration: BoxDecoration(
            color: whiteColor,
            boxShadow: boxShadow2,
          ),
          child: Column(
            children: [
              Row(
                children: [
                  Expanded(
                    child: Padding(
                      padding: const EdgeInsets.symmetric(
                          horizontal: fixPadding * 2.0),
                      child: Text(
                        itemData['title'].toString(),
                        style: medium17Primary,
                        overflow: TextOverflow.ellipsis,
                      ),
                    ),
                  ),
                  Container(
                    padding: const EdgeInsets.symmetric(
                        vertical: fixPadding * 0.8, horizontal: fixPadding / 2),
                    width: 110.0,
                    decoration: BoxDecoration(
                      color: itemData['status'] == "Confirmed"
                          ? greenColor
                          : const Color(0xFFE49824),
                      borderRadius: languageValue == 4
                          ? const BorderRadius.only(
                              bottomRight: Radius.circular(5.0),
                            )
                          : const BorderRadius.only(
                              bottomLeft: Radius.circular(5.0),
                            ),
                    ),
                    child: Text(
                      itemData['status'] == "Confirmed"
                          ? tr(context, 'book_amenities.confirmed')
                          : tr(context, 'book_amenities.pending'),
                      style: medium16White,
                      textAlign: TextAlign.center,
                      overflow: TextOverflow.ellipsis,
                    ),
                  )
                ],
              ),
              Padding(
                padding:
                    const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
                child: Row(
                  children: [
                    Expanded(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            "${tr(context, 'book_amenities.confirm_by')} : ${itemData['confirmBy']}",
                            style: regular15Black,
                            overflow: TextOverflow.ellipsis,
                          ),
                          height5Space,
                          Text(
                            "${itemData['fromToDate']}",
                            style: regular15Black,
                            overflow: TextOverflow.ellipsis,
                          ),
                          height5Space,
                          Text(
                            "${itemData['time']}",
                            style: regular15Black,
                            overflow: TextOverflow.ellipsis,
                          ),
                        ],
                      ),
                    ),
                    widthSpace,
                    Text(
                      itemData['isPaid'] == false
                          ? tr(context, 'book_amenities.free')
                          : itemData['price'].toString(),
                      style: medium18Primary,
                    )
                  ],
                ),
              )
            ],
          ),
        );
      },
      itemCount: amenitiesList.length,
    );
  }

  topImage() {
    return Image.asset(
      "assets/community/book-amenities.png",
      height: 128.0,
      width: double.maxFinite,
      fit: BoxFit.cover,
    );
  }
}
