import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/calendar_dialog.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

class BookServiceScreen extends StatefulWidget {
  const BookServiceScreen({super.key});

  @override
  State<BookServiceScreen> createState() => _BookServiceScreenState();
}

class _BookServiceScreenState extends State<BookServiceScreen> {
  String? selectedService;

  final serviceList = [
    "Carpet shampooing",
    "Sofa shampooing",
    "Full home clean",
    "Floor polishing",
    "Aquarium cleaning"
  ];

  DateTime? selectedDate;

  TimeOfDay? selectedTime;

  @override
  Widget build(BuildContext context) {
    final size = MediaQuery.sizeOf(context);
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'book_service.book_home_cleaning'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.all(fixPadding * 2.0),
        children: [
          topLogoAndTitle(),
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          service(context, size),
          heightSpace,
          heightSpace,
          height5Space,
          bookVisit(context),
          heightSpace,
          heightSpace,
          height5Space,
          briefProblemField(size)
        ],
      ),
      bottomNavigationBar: submitButton(context),
    );
  }

  submitButton(BuildContext context) {
    return Padding(
      padding: EdgeInsets.only(
        bottom: MediaQuery.viewInsetsOf(context).bottom,
      ),
      child: GestureDetector(
        onTap: () {
          Navigator.pop(context);
        },
        child: Container(
          padding: const EdgeInsets.symmetric(
              horizontal: fixPadding * 2.0, vertical: fixPadding * 1.1),
          margin: const EdgeInsets.symmetric(
              horizontal: fixPadding * 2.0, vertical: fixPadding * 2.5),
          width: double.maxFinite,
          decoration: BoxDecoration(
            color: primaryColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: buttonShadow,
          ),
          child: Text(
            tr(context, 'book_service.submit'),
            style: medium20White,
            overflow: TextOverflow.ellipsis,
            textAlign: TextAlign.center,
          ),
        ),
      ),
    );
  }

  Widget briefProblemField(Size size) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'book_service.brief_your_problem')),
        heightSpace,
        Container(
          height: size.height * 0.15,
          width: double.maxFinite,
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            style: regular15Black,
            cursorColor: primaryColor,
            expands: true,
            minLines: null,
            maxLines: null,
            textAlignVertical: TextAlignVertical.top,
            decoration: InputDecoration(
              border: InputBorder.none,
              focusedBorder: focusedBorder,
              hintText: tr(context, 'book_service.write_your_problem'),
              hintStyle: regular15Grey,
              isDense: true,
              contentPadding: const EdgeInsets.symmetric(
                  vertical: fixPadding * 1.4, horizontal: fixPadding * 1.5),
            ),
          ),
        )
      ],
    );
  }

  Widget bookVisit(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'book_service.book_visit_on')),
        heightSpace,
        Row(
          children: [
            selectDateField(context),
            widthSpace,
            widthSpace,
            selectTime(context)
          ],
        )
      ],
    );
  }

  Widget selectTime(BuildContext context) {
    return Expanded(
      child: GestureDetector(
        onTap: () async {
          final pickedTime = await showTimePicker(
            context: context,
            initialTime: selectedTime ?? TimeOfDay.now(),
            cancelText: tr(context, 'book_service.CANCEL'),
            confirmText: tr(context, 'book_service.OK'),
          );
          if (pickedTime != null) {
            setState(() {
              selectedTime = pickedTime;
            });
          }
        },
        child: Container(
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.3, horizontal: fixPadding),
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: selectedTime == null
              ? Text(
                  tr(context, 'book_service.select_time'),
                  style: regular15Grey,
                  overflow: TextOverflow.ellipsis,
                )
              : Text(
                  selectedTime!.format(context),
                  style: regular15Black,
                  overflow: TextOverflow.ellipsis,
                ),
        ),
      ),
    );
  }

  Widget selectDateField(BuildContext context) {
    return Expanded(
      child: GestureDetector(
        onTap: () {
          showDialog(
            context: context,
            builder: (context) {
              return CalendarDialog(selectedDate: selectedDate);
            },
          ).then((value) {
            if (value != null) {
              setState(() {
                selectedDate = value;
              });
            }
          });
        },
        child: Container(
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.4, horizontal: fixPadding),
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: selectedDate == null
              ? Text(
                  tr(context, 'book_service.select_date'),
                  style: regular15Grey,
                  overflow: TextOverflow.ellipsis,
                )
              : Text(
                  DateFormat("dd MMM yyyy",
                          Localizations.localeOf(context).toString())
                      .format(selectedDate!),
                  style: regular15Black,
                  overflow: TextOverflow.ellipsis,
                ),
        ),
      ),
    );
  }

  Widget service(BuildContext context, Size size) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        title(tr(context, 'book_service.service')),
        heightSpace,
        GestureDetector(
          onTap: () {
            String? service = selectedService;
            selectServiceBottomSheet(context, size, service);
          },
          child: Container(
            padding: const EdgeInsets.symmetric(
                vertical: fixPadding * 1.3, horizontal: fixPadding * 1.5),
            decoration: BoxDecoration(
              color: whiteColor,
              borderRadius: BorderRadius.circular(10.0),
              boxShadow: boxShadow2,
            ),
            child: Row(
              children: [
                Expanded(
                  child: selectedService == null
                      ? Text(
                          tr(context, 'book_service.select_service'),
                          style: regular15Grey,
                          overflow: TextOverflow.ellipsis,
                        )
                      : Text(
                          selectedService.toString(),
                          style: regular15Black,
                          overflow: TextOverflow.ellipsis,
                        ),
                ),
                widthSpace,
                const Icon(
                  Icons.arrow_drop_down,
                  color: greyColor,
                )
              ],
            ),
          ),
        )
      ],
    );
  }

  Future<dynamic> selectServiceBottomSheet(
      BuildContext context, Size size, String? service) {
    return showModalBottomSheet(
      isScrollControlled: true,
      backgroundColor: whiteColor,
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.vertical(
          top: Radius.circular(20.0),
        ),
      ),
      context: context,
      builder: (context) {
        return StatefulBuilder(builder: (context, state) {
          return Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Padding(
                padding: const EdgeInsets.fromLTRB(fixPadding * 2.0,
                    fixPadding * 2.0, fixPadding * 1.5, fixPadding * 1.5),
                child: Text(
                  tr(context, 'book_service.select_service'),
                  style: medium18Black,
                  textAlign: TextAlign.center,
                ),
              ),
              ConstrainedBox(
                constraints: BoxConstraints(maxHeight: size.height - 230),
                child: SingleChildScrollView(
                  physics: const BouncingScrollPhysics(),
                  padding:
                      const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
                  child: Column(
                    children: List.generate(
                      serviceList.length,
                      (index) {
                        return InkWell(
                          splashColor: Colors.transparent,
                          onTap: () {
                            state(() {
                              service = serviceList[index];
                            });
                          },
                          child: Padding(
                            padding: const EdgeInsets.symmetric(
                                vertical: fixPadding * 1.5),
                            child: Row(
                              children: [
                                Expanded(
                                  child: Text(
                                    serviceList[index].toString(),
                                    style: regular16Black,
                                  ),
                                ),
                                widthSpace,
                                service == serviceList[index]
                                    ? Container(
                                        height: 22.0,
                                        width: 22.0,
                                        decoration: BoxDecoration(
                                          shape: BoxShape.circle,
                                          color: whiteColor,
                                          boxShadow: buttonShadow,
                                          border: Border.all(
                                            color: primaryColor,
                                            width: 8.0,
                                          ),
                                        ),
                                      )
                                    : Container(
                                        height: 22.0,
                                        width: 22.0,
                                        decoration: BoxDecoration(
                                            shape: BoxShape.circle,
                                            color: whiteColor,
                                            boxShadow: boxShadow),
                                      )
                              ],
                            ),
                          ),
                        );
                      },
                    ),
                  ),
                ),
              ),
              Padding(
                padding: const EdgeInsets.fromLTRB(fixPadding * 2.0,
                    fixPadding * 1.5, fixPadding * 2.0, fixPadding * 3.0),
                child: Row(
                  children: [
                    Expanded(
                      child: GestureDetector(
                        onTap: () {
                          Navigator.pop(context);
                        },
                        child: Container(
                          padding: const EdgeInsets.all(fixPadding * 1.1),
                          decoration: BoxDecoration(
                            color: whiteColor,
                            borderRadius: BorderRadius.circular(10.0),
                            boxShadow: boxShadow,
                          ),
                          alignment: Alignment.center,
                          child: Text(
                            tr(context, 'book_service.cancel'),
                            style: medium20Primary,
                            overflow: TextOverflow.ellipsis,
                          ),
                        ),
                      ),
                    ),
                    widthSpace,
                    widthSpace,
                    Expanded(
                      child: GestureDetector(
                        onTap: () {
                          setState(() {
                            selectedService = service;
                          });
                          Navigator.pop(context);
                        },
                        child: Container(
                          padding: const EdgeInsets.all(fixPadding * 1.1),
                          decoration: BoxDecoration(
                            color: primaryColor,
                            borderRadius: BorderRadius.circular(10.0),
                            boxShadow: buttonShadow,
                          ),
                          alignment: Alignment.center,
                          child: Text(
                            tr(context, 'book_service.okay'),
                            style: medium20White,
                            overflow: TextOverflow.ellipsis,
                          ),
                        ),
                      ),
                    )
                  ],
                ),
              )
            ],
          );
        });
      },
    );
  }

  Widget title(String text) {
    return Text(
      text,
      style: regular16Black,
    );
  }

  Widget topLogoAndTitle() {
    return Column(
      children: [
        Container(
          height: 100.0,
          width: 100.0,
          decoration: const BoxDecoration(
            shape: BoxShape.circle,
            color: primaryColor,
          ),
          alignment: Alignment.center,
          child: Image.asset(
            "assets/services/home-cleaner.png",
            height: 60.0,
            color: whiteColor,
          ),
        ),
        heightSpace,
        const Text(
          "Home cleaning",
          style: medium17Primary,
          textAlign: TextAlign.center,
        ),
      ],
    );
  }
}
