import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/column_builder.dart';
import 'package:flutter/material.dart';
import 'package:get_time_ago/get_time_ago.dart';

class ComplaintDetailScreen extends StatefulWidget {
  const ComplaintDetailScreen({super.key});

  @override
  State<ComplaintDetailScreen> createState() => _ComplaintDetailScreenState();
}

class _ComplaintDetailScreenState extends State<ComplaintDetailScreen> {
  final complaintImagesList = [
    "assets/complaint/image-1.png",
    "assets/complaint/image-2.png"
  ];

  final commentsList = [
    {
      "image": "assets/members/member-13.png",
      "name": "Jenny Wilson",
      "flatNo": "A-252",
      "time": "2min ago",
      "comment":
          "Lorem ipsum dolor sit amet consectetur. Sit sit smperdiet ut. Amet sapien pretium sed semper morbi ."
    },
    {
      "image": "assets/members/member-8.png",
      "name": "Leslie Alexander",
      "flatNo": "A-252",
      "time": "2min ago",
      "comment":
          "Lorem ipsum dolor sit amet consectetur. Sit sit smperdiet ut. Amet sapien pretium sed semper morbi ."
    },
    {
      "image": "assets/members/member-3.png",
      "name": "Savannah Nguyen",
      "flatNo": "A-252",
      "time": "2min ago",
      "comment":
          "Lorem ipsum dolor sit amet consectetur. Sit sit smperdiet ut. Amet sapien pretium sed semper morbi ."
    },
    {
      "image": "assets/members/member-14.png",
      "name": "Cody Fisher",
      "flatNo": "A-252",
      "time": "2min ago",
      "comment":
          "Lorem ipsum dolor sit amet consectetur. Sit sit smperdiet ut. Amet sapien pretium sed semper morbi ."
    },
  ];

  TextEditingController commentsController = TextEditingController();

  @override
  Widget build(BuildContext context) {
    final complaintData = ModalRoute.of(context)!.settings.arguments as Map;

    final size = MediaQuery.sizeOf(context);

    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding:
            const EdgeInsets.only(top: fixPadding * 2.0, bottom: fixPadding),
        children: [
          complaintDetail(complaintData),
          complaintData['isResolved'] == true
              ? reOpenButton()
              : markAsReslovedButton(size),
          complaintImages(),
          heightSpace,
          heightSpace,
          recentComments()
        ],
      ),
      bottomNavigationBar: commentField(),
    );
  }

  Widget commentField() {
    return Container(
      margin: EdgeInsets.only(bottom: MediaQuery.viewInsetsOf(context).bottom),
      padding: const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
      decoration: BoxDecoration(
        color: whiteColor,
        boxShadow: boxShadow2,
      ),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Expanded(
            child: TextField(
              controller: commentsController,
              cursorColor: primaryColor,
              style: regular15Primary,
              decoration: InputDecoration(
                isDense: true,
                border: InputBorder.none,
                contentPadding:
                    const EdgeInsets.symmetric(vertical: fixPadding * 1.8),
                hintText: tr(context, 'complaint_detail.write_message'),
                hintStyle: regular15Primary,
              ),
            ),
          ),
          Container(
            margin: const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
            height: 40.0,
            width: 1.0,
            color: greyD4Color,
          ),
          sendButton()
        ],
      ),
    );
  }

  Widget sendButton() {
    return GestureDetector(
      onTap: () {
        if (commentsController.text.isNotEmpty) {
          setState(() {
            commentsList.add({
              "image": "assets/profile/user-image.png",
              "name": "Ronald Richards",
              "flatNo": "A-252",
              "time": GetTimeAgo.parse(DateTime.now()),
              "comment": commentsController.text,
            });
            commentsController.clear();
            commentsList;
          });
        }
      },
      child: Container(
        height: 37.0,
        width: 37.0,
        decoration: BoxDecoration(
          shape: BoxShape.circle,
          color: whiteColor,
          boxShadow: boxShadow2,
        ),
        child: const Icon(
          Icons.send,
          color: primaryColor,
          size: 20.0,
        ),
      ),
    );
  }

  Widget recentComments() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Padding(
          padding: const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
          child: Text(
            tr(context, 'complaint_detail.recent_comments'),
            style: medium16Black,
          ),
        ),
        ColumnBuilder(
          itemBuilder: (context, index) {
            final commentData = commentsList[index];
            return Container(
              margin: const EdgeInsets.symmetric(vertical: fixPadding),
              width: double.maxFinite,
              color: whiteColor,
              padding: const EdgeInsets.symmetric(
                horizontal: fixPadding * 2.0,
                vertical: fixPadding * 1.5,
              ),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    children: [
                      Container(
                        height: 46.0,
                        width: 46.0,
                        decoration: BoxDecoration(
                          shape: BoxShape.circle,
                          image: DecorationImage(
                              image: AssetImage(
                                commentData["image"].toString(),
                              ),
                              fit: BoxFit.cover),
                        ),
                      ),
                      widthBox(fixPadding * 0.8),
                      Expanded(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              commentData['name'].toString(),
                              style: regular15Black,
                              overflow: TextOverflow.ellipsis,
                            ),
                            height5Space,
                            Text(
                              commentData['flatNo'].toString(),
                              style: regular15Grey,
                              overflow: TextOverflow.ellipsis,
                            )
                          ],
                        ),
                      ),
                      widthSpace,
                      Text(
                        commentData['time'].toString(),
                        style: regular15Grey,
                      )
                    ],
                  ),
                  heightSpace,
                  Text(
                    commentData['comment'].toString(),
                    style: regular15Grey,
                  )
                ],
              ),
            );
          },
          itemCount: commentsList.length,
        )
      ],
    );
  }

  Widget complaintImages() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Padding(
          padding: const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
          child: Text(
            tr(context, 'complaint_detail.complaint_image'),
            style: medium16Black,
          ),
        ),
        heightSpace,
        Container(
          width: double.maxFinite,
          color: whiteColor,
          child: SingleChildScrollView(
            physics: const BouncingScrollPhysics(),
            scrollDirection: Axis.horizontal,
            padding: const EdgeInsets.symmetric(
                horizontal: fixPadding, vertical: fixPadding * 2.0),
            child: Row(
              children: List.generate(
                complaintImagesList.length,
                (index) {
                  return Container(
                    margin: const EdgeInsets.symmetric(horizontal: fixPadding),
                    height: 100,
                    width: 110.0,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10.0),
                      image: DecorationImage(
                        image: AssetImage(
                          complaintImagesList[index].toString(),
                        ),
                        fit: BoxFit.cover,
                      ),
                    ),
                  );
                },
              ),
            ),
          ),
        )
      ],
    );
  }

  Widget reOpenButton() {
    return Container(
      padding: const EdgeInsets.symmetric(
          vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
      margin: const EdgeInsets.all(fixPadding * 2.0),
      width: double.maxFinite,
      decoration: BoxDecoration(
        color: primaryColor,
        borderRadius: BorderRadius.circular(10.0),
        boxShadow: buttonShadow,
      ),
      child: Text(
        tr(context, 'complaint_detail.reopen'),
        style: medium20White,
        overflow: TextOverflow.ellipsis,
        textAlign: TextAlign.center,
      ),
    );
  }

  Widget markAsReslovedButton(Size size) {
    return Container(
      padding: const EdgeInsets.symmetric(
          vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
      margin: const EdgeInsets.all(fixPadding * 2.0),
      width: double.maxFinite,
      decoration: BoxDecoration(
        color: primaryColor,
        borderRadius: BorderRadius.circular(10.0),
        boxShadow: buttonShadow,
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          const Icon(
            Icons.done,
            color: whiteColor,
          ),
          widthSpace,
          ConstrainedBox(
            constraints: BoxConstraints(maxWidth: size.width - 130),
            child: Text(
              tr(context, 'complaint_detail.mark_as_resolved'),
              style: medium20White,
              overflow: TextOverflow.ellipsis,
            ),
          )
        ],
      ),
    );
  }

  Widget complaintDetail(Map<dynamic, dynamic> complaintData) {
    return Container(
      padding: const EdgeInsets.symmetric(
          horizontal: fixPadding * 2.0, vertical: fixPadding),
      width: double.maxFinite,
      decoration: BoxDecoration(
        color: whiteColor,
        boxShadow: boxShadow2,
      ),
      child: Row(
        children: [
          Container(
            height: 110.0,
            width: 105.0,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10.0),
              image: DecorationImage(
                image: AssetImage(
                  complaintData['image'].toString(),
                ),
                fit: BoxFit.cover,
              ),
            ),
          ),
          widthSpace,
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  complaintData['title'].toString(),
                  style: regular17Black,
                  overflow: TextOverflow.ellipsis,
                ),
                Text(
                  complaintData['detail'].toString(),
                  style: regular16Grey,
                  overflow: TextOverflow.ellipsis,
                ),
                Text(
                  "${tr(context, 'complaint_detail.raised_by')} : ${complaintData['raisedBy']}",
                  style: regular16Grey,
                  overflow: TextOverflow.ellipsis,
                ),
                Text(
                  complaintData['timeDate'].toString(),
                  style: regular15Grey,
                  overflow: TextOverflow.ellipsis,
                ),
                complaintData['isResolved'] == true
                    ? Text(
                        tr(context, 'complaint_detail.resolved'),
                        style: medium16Green,
                        overflow: TextOverflow.ellipsis,
                      )
                    : Text(
                        tr(context, 'complaint_detail.new'),
                        style: medium16Primary,
                        overflow: TextOverflow.ellipsis,
                      ),
              ],
            ),
          )
        ],
      ),
    );
  }
}
