import 'package:awesome_card/credit_card.dart';
import 'package:extended_masked_text/extended_masked_text.dart';
import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class CreditCardScreen extends StatefulWidget {
  const CreditCardScreen({super.key});

  @override
  State<CreditCardScreen> createState() => _CreditCardScreenState();
}

class _CreditCardScreenState extends State<CreditCardScreen> {
  final formKey = GlobalKey<FormState>();
  TextEditingController number =
      MaskedTextController(mask: '0000 0000 0000 0000');
  late TextEditingController validThru = MaskedTextController(mask: "00/00");
  late TextEditingController cvv = MaskedTextController(mask: "000");
  late TextEditingController holder = TextEditingController();

  FocusNode cvvFocus = FocusNode();

  @override
  void initState() {
    super.initState();

    // listen to state changes within the form field controllers
    number.addListener(() => setState(() {}));
    validThru.addListener(() => setState(() {}));
    cvv.addListener(() => setState(() {}));
    holder.addListener(() => setState(() {}));
    cvvFocus.addListener(() => setState(() {}));
  }

  @override
  Widget build(BuildContext context) {
    final size = MediaQuery.sizeOf(context);
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'credit_card.credit_card'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        padding: const EdgeInsets.all(fixPadding * 2),
        physics: const BouncingScrollPhysics(),
        children: [
          creditcardUi(size),
          heightSpace,
          heightSpace,
          heightSpace,
          creditcardForm(),
        ],
      ),
      bottomNavigationBar: continueButton(),
    );
  }

  Widget continueButton() {
    return Padding(
      padding: EdgeInsets.only(
        bottom: MediaQuery.viewInsetsOf(context).bottom,
      ),
      child: GestureDetector(
        onTap: () {
          Navigator.pushNamed(context, '/paymentSuccess');
        },
        child: Container(
          margin: const EdgeInsets.symmetric(
              vertical: fixPadding * 2.5, horizontal: fixPadding * 2.0),
          padding: const EdgeInsets.symmetric(
              horizontal: fixPadding * 2.0, vertical: fixPadding * 1.1),
          decoration: BoxDecoration(
            color: primaryColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: buttonShadow,
          ),
          child: Text(
            tr(context, 'credit_card.continue'),
            style: medium20White,
            overflow: TextOverflow.ellipsis,
            textAlign: TextAlign.center,
          ),
        ),
      ),
    );
  }

  Widget creditcardUi(Size size) {
    return CreditCard(
      cardNumber: number.text,
      cardExpiry: validThru.text,
      cardHolderName: holder.text,
      cvv: cvv.text,
      width: double.maxFinite,
      bankName: tr(context, 'credit_card.credit_card'),
      horizontalMargin: 0,
      showBackSide: cvvFocus.hasFocus ? true : false,
      frontBackground: Image.asset(
        "assets/payment/card-bgImage.png",
        fit: BoxFit.cover,
      ),
      backBackground: Image.asset(
        "assets/payment/card-bgImage.png",
        fit: BoxFit.cover,
      ),
      backTextColor: whiteColor,
      frontTextColor: whiteColor,
      frontLayout: Container(
        decoration: const BoxDecoration(
          image: DecorationImage(
            image: AssetImage("assets/payment/card-bgImage.png"),
            fit: BoxFit.cover,
          ),
        ),
        padding: const EdgeInsets.all(fixPadding * 2.0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(
              tr(context, 'credit_card.credit_card'),
              style: semibold14White,
            ),
            width5Space,
            Text(
              number.text.isEmpty
                  ? "XXXX XXXX XXXX XXXX"
                  : number.text.toString(),
              style: semibold16White,
              overflow: TextOverflow.ellipsis,
            ),
            Row(
              children: [
                const Text(
                  "Exp.\nDate",
                  style: TextStyle(
                    color: whiteColor,
                    fontSize: 10.0,
                  ),
                ),
                width5Space,
                Text(
                  validThru.text.isEmpty ? "XX/YY" : validThru.text.toString(),
                  style: semibold14White,
                  overflow: TextOverflow.ellipsis,
                )
              ],
            ),
            Row(
              children: [
                Expanded(
                  child: Text(
                    holder.text.isEmpty ? "Name" : holder.text.toString(),
                    style: semibold14White,
                    overflow: TextOverflow.ellipsis,
                  ),
                ),
                widthSpace,
                Image.asset(
                  "assets/payment/Mastercard-Logo.png",
                  height: 30.0,
                  fit: BoxFit.cover,
                )
              ],
            )
          ],
        ),
      ),
      backLayout: Container(
        decoration: const BoxDecoration(
          image: DecorationImage(
            image: AssetImage("assets/payment/card-bgImage.png"),
            fit: BoxFit.cover,
          ),
        ),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            heightSpace,
            heightSpace,
            Container(
              height: 50.0,
              width: double.maxFinite,
              color: originalBlackColor,
            ),
            heightSpace,
            heightSpace,
            Row(
              children: [
                Expanded(
                  child: Container(
                    height: 45.0,
                    color: greyD4Color,
                  ),
                ),
                Container(
                  padding:
                      const EdgeInsets.symmetric(horizontal: fixPadding / 2),
                  height: 35.0,
                  width: 80.0,
                  color: whiteColor,
                  alignment: languageValue == 4
                      ? Alignment.centerRight
                      : Alignment.centerLeft,
                  child: Text(
                    cvv.text.isEmpty ? "" : cvv.text.toString(),
                    style: regular14Black,
                    overflow: TextOverflow.ellipsis,
                  ),
                )
              ],
            )
          ],
        ),
      ),
      showShadow: false,
      height: 215.0,
    );
  }

  Widget creditcardForm() {
    var boxDecoration = BoxDecoration(
      borderRadius: BorderRadius.circular(10.0),
      boxShadow: boxShadow2,
      color: whiteColor,
    );
    return Form(
      key: formKey,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          fieldTitle(tr(context, 'credit_card.name_on_card')),
          heightSpace,
          Container(
            decoration: boxDecoration,
            child: TextField(
              controller: holder,
              keyboardType: TextInputType.name,
              cursorColor: primaryColor,
              style: regular15Black,
              decoration: inputDecoration(
                hintText: tr(context, 'credit_card.enter_name_on_card'),
              ),
            ),
          ),
          heightSpace,
          heightSpace,
          height5Space,
          fieldTitle(tr(context, 'credit_card.card_number')),
          heightSpace,
          Container(
            decoration: boxDecoration,
            child: TextField(
              controller: number,
              keyboardType: TextInputType.number,
              cursorColor: primaryColor,
              style: regular15Black,
              decoration: inputDecoration(
                hintText: tr(context, 'credit_card.enter_card_number'),
              ),
            ),
          ),
          heightSpace,
          heightSpace,
          height5Space,
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Flexible(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    fieldTitle(tr(context, 'credit_card.expiry_date')),
                    heightSpace,
                    Container(
                      decoration: boxDecoration,
                      child: TextField(
                        controller: validThru,
                        keyboardType: TextInputType.number,
                        cursorColor: primaryColor,
                        style: regular15Black,
                        decoration: inputDecoration(
                          hintText: "XX/YY",
                        ),
                      ),
                    ),
                  ],
                ),
              ),
              widthSpace,
              widthSpace,
              Flexible(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    fieldTitle("CVV"),
                    heightSpace,
                    Container(
                      decoration: boxDecoration,
                      child: TextField(
                        controller: cvv,
                        focusNode: cvvFocus,
                        keyboardType: TextInputType.number,
                        cursorColor: primaryColor,
                        style: regular15Black,
                        obscureText: true,
                        obscuringCharacter: "*",
                        decoration: inputDecoration(
                          hintText: "CVV",
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            ],
          )
        ],
      ),
    );
  }

  Text fieldTitle(String title) {
    return Text(
      title,
      style: regular16Black,
      overflow: TextOverflow.ellipsis,
    );
  }

  InputDecoration inputDecoration({required String hintText}) {
    return InputDecoration(
      hintText: hintText,
      hintStyle: regular15Grey,
      border: InputBorder.none,
      contentPadding: const EdgeInsets.symmetric(
          vertical: fixPadding * 1.4, horizontal: fixPadding * 1.6),
      focusedBorder: focusedBorder,
      isDense: true,
    );
  }
}
