import 'package:dotted_border/dotted_border.dart';
import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';
import 'package:iconify_flutter/iconify_flutter.dart';
import 'package:iconify_flutter/icons/ep.dart';
import 'package:iconify_flutter/icons/icomoon_free.dart';

class GatePassScreen extends StatefulWidget {
  const GatePassScreen({super.key});

  @override
  State<GatePassScreen> createState() => _GatePassScreenState();
}

class _GatePassScreenState extends State<GatePassScreen> {
  @override
  Widget build(BuildContext context) {
    final size = MediaQuery.sizeOf(context);
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        centerTitle: false,
        backgroundColor: whiteColor,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.fromLTRB(
          fixPadding * 2.0,
          fixPadding * 3.0,
          fixPadding * 2.0,
          fixPadding * 2.0,
        ),
        children: [
          getPass(size),
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          Row(
            children: [
              shareButton(),
              widthSpace,
              widthSpace,
              downloadButton(),
            ],
          ),
        ],
      ),
    );
  }

  Widget downloadButton() {
    return Expanded(
      child: GestureDetector(
        onTap: () {
          Navigator.pop(context);
        },
        child: Container(
          padding: const EdgeInsets.all(fixPadding * 1.2),
          decoration: BoxDecoration(
            color: primaryColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: buttonShadow,
          ),
          alignment: Alignment.center,
          child: Text(
            tr(context, 'gate_pass.download'),
            style: medium20White,
            overflow: TextOverflow.ellipsis,
            textAlign: TextAlign.center,
          ),
        ),
      ),
    );
  }

  Widget shareButton() {
    return Expanded(
      child: GestureDetector(
        onTap: () {
          Navigator.pop(context);
        },
        child: Container(
          padding: const EdgeInsets.all(fixPadding * 1.2),
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow,
          ),
          alignment: Alignment.center,
          child: Text(
            tr(context, 'gate_pass.share'),
            style: regular20Grey,
            overflow: TextOverflow.ellipsis,
            textAlign: TextAlign.center,
          ),
        ),
      ),
    );
  }

  Widget getPass(Size size) {
    return Container(
      padding: const EdgeInsets.symmetric(vertical: fixPadding * 2.0),
      width: double.maxFinite,
      decoration: BoxDecoration(
        color: whiteColor,
        borderRadius: BorderRadius.circular(10.0),
        boxShadow: boxShadow,
      ),
      child: Column(
        children: [
          Padding(
            padding: const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
            child: Column(
              children: [
                Text(
                  tr(context, 'gate_pass.gate_pass'),
                  style: medium20Primary,
                  textAlign: TextAlign.center,
                ),
                heightSpace,
                heightSpace,
                height5Space,
                Iconify(
                  IcomoonFree.qrcode,
                  color: blackColor,
                  size: size.height * 0.25,
                ),
                heightSpace,
                heightSpace,
                heightSpace,
                Container(
                  padding: const EdgeInsets.symmetric(
                    horizontal: fixPadding * 1.2,
                    vertical: fixPadding * 1.3,
                  ),
                  width: double.maxFinite,
                  decoration: BoxDecoration(
                    color: whiteColor,
                    borderRadius: BorderRadius.circular(10.0),
                    boxShadow: boxShadow,
                  ),
                  child: const Row(
                    children: [
                      Expanded(
                        child: Text(
                          "541125",
                          style: regular17Black,
                          overflow: TextOverflow.ellipsis,
                        ),
                      ),
                      widthSpace,
                      Iconify(
                        Ep.copy_document,
                        color: primaryColor,
                      ),
                    ],
                  ),
                ),
                heightSpace,
                heightSpace,
                Text(
                  tr(context, 'gate_pass.text'),
                  style: regular16Grey,
                  textAlign: TextAlign.center,
                ),
              ],
            ),
          ),
          SizedBox(
            height: 55.0,
            child: Stack(
              clipBehavior: Clip.none,
              children: [
                Positioned(
                  left: -33.0,
                  right: -33.0,
                  child: Row(
                    children: [
                      Container(
                        height: 66.0,
                        width: 66.0,
                        decoration: const BoxDecoration(
                          shape: BoxShape.circle,
                          color: screenBgColor,
                        ),
                      ),
                      Expanded(
                        child: DottedBorder(
                          // ✅ new API for v3.1.0
                          options: RectDottedBorderOptions(
                            dashPattern: const [2, 5],
                            color: greyColor,
                            padding: EdgeInsets.zero,
                            strokeWidth: 1,
                          ),
                          child: const SizedBox(
                            width: double.maxFinite,
                            height: 1,
                          ),
                        ),
                      ),
                      Container(
                        height: 66.0,
                        width: 66.0,
                        decoration: const BoxDecoration(
                          shape: BoxShape.circle,
                          color: screenBgColor,
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
          const Padding(
            padding: EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
            child: Column(
              children: [
                Text(
                  "Brooklyn Simmons",
                  style: medium17Black,
                  textAlign: TextAlign.center,
                ),
                heightSpace,
                Text(
                  "Guest at B-105",
                  style: regular15Grey,
                  textAlign: TextAlign.center,
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }
}
