import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/column_builder.dart';
import 'package:flutter/material.dart';

class HelpDeskScreen extends StatefulWidget {
  const HelpDeskScreen({super.key});

  @override
  State<HelpDeskScreen> createState() => _HelpDeskScreenState();
}

class _HelpDeskScreenState extends State<HelpDeskScreen> {
  final helpList = [
    {
      "image": "assets/members/member-12.png",
      "title": "Plumbing (Community)",
      "detail": "Power fluctuate sometime",
      "raisedBy": "Jerica Patel",
      "timeDate": "22 aug, 3:30 PM",
      "isResolved": false
    },
    {
      "image": "assets/members/member-4.png",
      "title": "Electricity (personal)",
      "detail": "Power fluctuate sometime",
      "raisedBy": "Jerica Patel",
      "timeDate": "22 aug, 3:30 PM",
      "isResolved": true
    },
    {
      "image": "assets/members/member-8.png",
      "title": "Parking (Community)",
      "detail": "Water leakage in parking area.",
      "raisedBy": "Jane cooper",
      "timeDate": "22 aug, 3:30 PM",
      "isResolved": false
    },
    {
      "image": "assets/members/member-3.png",
      "title": "Electricity (personal)",
      "detail": "Power fluctuate sometime",
      "raisedBy": "Jerica Patel",
      "timeDate": "22 aug, 3:30 PM",
      "isResolved": true
    },
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'help_desk.help_desk'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.only(bottom: fixPadding),
        children: [
          topImage(),
          heightSpace,
          helpListContent(),
        ],
      ),
      bottomNavigationBar: raisedNewComplaintButton(),
    );
  }

  raisedNewComplaintButton() {
    return GestureDetector(
      onTap: () {
        Navigator.pushNamed(context, '/raisedNewComplaint');
      },
      child: Container(
        padding: const EdgeInsets.symmetric(
            vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
        margin: const EdgeInsets.symmetric(
            horizontal: fixPadding * 2.0, vertical: fixPadding * 2.5),
        decoration: BoxDecoration(
          color: primaryColor,
          borderRadius: BorderRadius.circular(10.0),
          boxShadow: buttonShadow,
        ),
        child: Text(
          tr(context, 'help_desk.raised_new_complaint'),
          style: medium20White,
          textAlign: TextAlign.center,
          overflow: TextOverflow.ellipsis,
        ),
      ),
    );
  }

  helpListContent() {
    return ColumnBuilder(
      itemBuilder: (context, index) {
        final itemData = helpList[index];
        return GestureDetector(
          onTap: () {
            Navigator.pushNamed(context, '/complaintDetail',
                arguments: itemData);
          },
          child: Container(
            margin: const EdgeInsets.symmetric(vertical: fixPadding),
            padding: const EdgeInsets.symmetric(
                horizontal: fixPadding * 2.0, vertical: fixPadding),
            width: double.maxFinite,
            decoration: BoxDecoration(
              color: whiteColor,
              boxShadow: boxShadow2,
            ),
            child: Row(
              children: [
                Container(
                  height: 110.0,
                  width: 105.0,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10.0),
                    image: DecorationImage(
                      image: AssetImage(
                        itemData['image'].toString(),
                      ),
                      fit: BoxFit.cover,
                    ),
                  ),
                ),
                widthSpace,
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        itemData['title'].toString(),
                        style: regular17Black,
                        overflow: TextOverflow.ellipsis,
                      ),
                      Text(
                        itemData['detail'].toString(),
                        style: regular16Grey,
                        overflow: TextOverflow.ellipsis,
                      ),
                      Text(
                        "${tr(context, 'help_desk.raised_By')} : ${itemData['raisedBy']}",
                        style: regular16Grey,
                        overflow: TextOverflow.ellipsis,
                      ),
                      Text(
                        itemData['timeDate'].toString(),
                        style: regular15Grey,
                        overflow: TextOverflow.ellipsis,
                      ),
                      itemData['isResolved'] == true
                          ? Text(
                              tr(context, 'help_desk.resolved'),
                              style: medium16Green,
                              overflow: TextOverflow.ellipsis,
                            )
                          : Text(
                              tr(context, 'help_desk.new'),
                              style: medium16Primary,
                              overflow: TextOverflow.ellipsis,
                            ),
                    ],
                  ),
                )
              ],
            ),
          ),
        );
      },
      itemCount: helpList.length,
    );
  }

  topImage() {
    return Image.asset(
      "assets/community/book-amenities.png",
      height: 128.0,
      width: double.maxFinite,
      fit: BoxFit.cover,
    );
  }
}
