import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class MessagesScreen extends StatefulWidget {
  const MessagesScreen({super.key});

  @override
  State<MessagesScreen> createState() => _MessagesScreenState();
}

class _MessagesScreenState extends State<MessagesScreen> {
  final messagesList = [
    {
      "image": "assets/members/member-14.png",
      "name": "Esther Howard",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-8.png",
      "name": "Robert Fox",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-10.png",
      "name": "Jacob Jones",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-15.png",
      "name": "Savannah Nguyen",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-16.png",
      "name": "Ralph Edwards",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-6.png",
      "name": "Annette Black",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-17.png",
      "name": "Devon Lane",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-18.png",
      "name": "Theresa Webb",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-19.png",
      "name": "Eleanor Pena",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-20.png",
      "name": "Bessie Cooper",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-21.png",
      "name": "Cody Fisher",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
    {
      "image": "assets/members/member-22.png",
      "name": "Eleanor Pena",
      "lastMessage": "Good morning..!",
      "time": "02 : 30 PM"
    },
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: true,
        titleSpacing: 20.0,
        title: Text(
          tr(context, 'message.message'),
          style: medium20Primary,
        ),
      ),
      body: messagesListContent(),
    );
  }

  Widget messagesListContent() {
    return ListView.builder(
      physics: const BouncingScrollPhysics(),
      padding: const EdgeInsets.symmetric(vertical: fixPadding * 1.25),
      itemCount: messagesList.length,
      itemBuilder: (context, index) {
        return GestureDetector(
          onTap: () {
            Navigator.pushNamed(context, '/chat',
                arguments: messagesList[index]);
          },
          child: Container(
            margin: const EdgeInsets.symmetric(vertical: fixPadding),
            width: double.maxFinite,
            padding: const EdgeInsets.symmetric(
                vertical: fixPadding * 0.75, horizontal: fixPadding * 2.0),
            color: whiteColor,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Expanded(
                  child: Row(
                    children: [
                      Container(
                        height: 39.0,
                        width: 39.0,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(5.0),
                          image: DecorationImage(
                            image: AssetImage(
                              messagesList[index]['image'].toString(),
                            ),
                            fit: BoxFit.cover,
                          ),
                        ),
                      ),
                      widthSpace,
                      Expanded(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              messagesList[index]['name'].toString(),
                              style: regular16Black,
                              overflow: TextOverflow.ellipsis,
                            ),
                            heightBox(fixPadding * 0.3),
                            Text(
                              messagesList[index]['lastMessage'].toString(),
                              style: regular14Grey,
                              overflow: TextOverflow.ellipsis,
                            )
                          ],
                        ),
                      )
                    ],
                  ),
                ),
                widthSpace,
                Text(
                  messagesList[index]['time'].toString(),
                  style: regular14Grey,
                )
              ],
            ),
          ),
        );
      },
    );
  }
}
