import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class PaymentSuccessScreen extends StatefulWidget {
  const PaymentSuccessScreen({super.key});

  @override
  State<PaymentSuccessScreen> createState() => _PaymentSuccessScreenState();
}

class _PaymentSuccessScreenState extends State<PaymentSuccessScreen> {
  @override
  Widget build(BuildContext context) {
    return PopScope(
      canPop: false,
      onPopInvokedWithResult: (didPop, result) =>
          Navigator.pushNamedAndRemoveUntil(
              context, '/bottombar', (route) => false),
      child: Scaffold(
        body: Center(
          child: ListView(
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
            padding: const EdgeInsets.all(fixPadding * 2.0),
            children: [
              Stack(
                children: [
                  successContent(),
                  doneLogo(),
                ],
              )
            ],
          ),
        ),
        bottomNavigationBar: backToHomeButton(context),
      ),
    );
  }

  backToHomeButton(BuildContext context) {
    return Column(
      mainAxisSize: MainAxisSize.min,
      children: [
        TextButton(
          onPressed: () {
            Navigator.pushNamedAndRemoveUntil(
                context, '/bottombar', (route) => false);
          },
          child: Text(
            tr(context, 'payment_success.back_to_home'),
            style: medium18Primary,
          ),
        )
      ],
    );
  }

  successContent() {
    return Container(
      width: double.maxFinite,
      padding: const EdgeInsets.all(fixPadding * 2.0),
      margin: const EdgeInsets.only(top: fixPadding * 5.5),
      decoration: BoxDecoration(
        color: whiteColor,
        borderRadius: BorderRadius.circular(10.0),
        boxShadow: boxShadow,
      ),
      child: Column(
        children: [
          heightBox(fixPadding * 5.5),
          Text(
            tr(context, 'payment_success.payment_success'),
            style: medium20Primary,
            textAlign: TextAlign.center,
          ),
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          Row(
            children: [
              Expanded(
                child: Text(
                  tr(context, 'payment_success.maintenance'),
                  style: regular16Black,
                ),
              ),
              widthSpace,
              Text(
                tr(context, 'payment_success.paid'),
                style: regular16Green,
              )
            ],
          ),
          heightSpace,
          heightSpace,
          height5Space,
          paymentDetailWidget(
              tr(context, 'payment_success.amount_paid'), '\$20.00'),
          heightSpace,
          heightSpace,
          height5Space,
          paymentDetailWidget(
              tr(context, 'payment_success.paid_on'), '25 feb 2024'),
          heightSpace,
          heightSpace,
          height5Space,
          paymentDetailWidget(
              tr(context, 'payment_success.paid_via'), 'Debit card'),
          heightSpace,
          heightSpace,
          height5Space,
          paymentDetailWidget(
              tr(context, 'payment_success.transaction_id'), 'AX214541452'),
          heightSpace,
          heightSpace,
          heightSpace,
          heightSpace,
          downloadReceiptButton(),
          heightSpace,
        ],
      ),
    );
  }

  downloadReceiptButton() {
    return Container(
      margin: const EdgeInsets.symmetric(horizontal: fixPadding * 2.0),
      padding: const EdgeInsets.symmetric(
          vertical: fixPadding, horizontal: fixPadding * 2.0),
      width: double.maxFinite,
      decoration: BoxDecoration(
        color: whiteColor,
        borderRadius: BorderRadius.circular(10.0),
        boxShadow: buttonShadow,
        border: Border.all(color: primaryColor),
      ),
      alignment: Alignment.center,
      child: Text(
        tr(context, 'payment_success.download_receipt'),
        style: medium20Primary,
        overflow: TextOverflow.ellipsis,
      ),
    );
  }

  paymentDetailWidget(String title, String detail) {
    return Row(
      children: [
        Expanded(
          child: Text(
            title,
            style: regular16Black,
          ),
        ),
        widthSpace,
        Text(
          detail,
          style: regular16Black,
        )
      ],
    );
  }

  doneLogo() {
    return Align(
      alignment: Alignment.center,
      child: Container(
        padding: const EdgeInsets.all(fixPadding * 0.8),
        decoration: BoxDecoration(
          color: const Color(0xFFFFE4DB),
          shape: BoxShape.circle,
          boxShadow: [
            BoxShadow(
              color: originalBlackColor.withOpacity(0.25),
              blurRadius: 3.4,
              offset: const Offset(0, 3.4),
            )
          ],
        ),
        child: Container(
          height: 100.0,
          width: 100.0,
          decoration: const BoxDecoration(
            shape: BoxShape.circle,
            color: primaryColor,
          ),
          alignment: Alignment.center,
          child: const Icon(
            Icons.done,
            color: whiteColor,
            size: 60.0,
          ),
        ),
      ),
    );
  }
}
