import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class HelpAndSupportScreen extends StatefulWidget {
  const HelpAndSupportScreen({super.key});

  @override
  State<HelpAndSupportScreen> createState() => _HelpAndSupportScreenState();
}

class _HelpAndSupportScreenState extends State<HelpAndSupportScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        centerTitle: false,
        backgroundColor: whiteColor,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'help_and_support.help_and_support'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: EdgeInsets.zero,
        children: [
          topImage(),
          Padding(
            padding: const EdgeInsets.all(fixPadding * 2.0),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                heightSpace,
                heightSpace,
                Center(
                  child: Text(
                    tr(context, 'help_and_support.help_and_support'),
                    style: medium18Black,
                    textAlign: TextAlign.center,
                  ),
                ),
                Center(
                  child: Text(
                    tr(context, 'help_and_support.tell_issue_improve'),
                    style: regular16Grey,
                    textAlign: TextAlign.center,
                  ),
                ),
                heightSpace,
                heightSpace,
                heightSpace,
                heightSpace,
                issueTypeField(),
                heightSpace,
                heightSpace,
                height5Space,
                messageField(),
              ],
            ),
          )
        ],
      ),
      bottomNavigationBar: submitButton(context),
    );
  }

  submitButton(BuildContext context) {
    return Padding(
      padding: EdgeInsets.only(bottom: MediaQuery.viewInsetsOf(context).bottom),
      child: GestureDetector(
        onTap: () {
          Navigator.pop(context);
        },
        child: Container(
          margin: const EdgeInsets.symmetric(
              horizontal: fixPadding * 2.0, vertical: fixPadding * 2.5),
          width: double.maxFinite,
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
          decoration: BoxDecoration(
            color: primaryColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: buttonShadow,
          ),
          child: Text(
            tr(context, 'help_and_support.submit'),
            style: medium20White,
            textAlign: TextAlign.center,
            overflow: TextOverflow.ellipsis,
          ),
        ),
      ),
    );
  }

  Widget messageField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        fieldTitle(tr(context, 'help_and_support.message')),
        heightSpace,
        Container(
          height: MediaQuery.sizeOf(context).height * 0.15,
          width: double.maxFinite,
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            style: regular15Black,
            cursorColor: primaryColor,
            expands: true,
            maxLines: null,
            minLines: null,
            textAlignVertical: TextAlignVertical.top,
            decoration: InputDecoration(
              border: InputBorder.none,
              focusedBorder: focusedBorder,
              isDense: true,
              hintText: tr(context, 'help_and_support.write_your_message_here'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  horizontal: fixPadding * 1.5, vertical: fixPadding * 1.3),
            ),
          ),
        )
      ],
    );
  }

  Widget issueTypeField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        fieldTitle(tr(context, 'help_and_support.issue_type')),
        heightSpace,
        Container(
          width: double.maxFinite,
          decoration: BoxDecoration(
            color: whiteColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: boxShadow2,
          ),
          child: TextField(
            style: regular15Black,
            cursorColor: primaryColor,
            decoration: InputDecoration(
              border: InputBorder.none,
              focusedBorder: focusedBorder,
              isDense: true,
              hintText: tr(context, 'help_and_support.enter_issue_type'),
              hintStyle: regular15Grey,
              contentPadding: const EdgeInsets.symmetric(
                  horizontal: fixPadding * 1.5, vertical: fixPadding * 1.4),
            ),
          ),
        )
      ],
    );
  }

  Widget fieldTitle(String title) {
    return Text(
      title,
      style: regular16Black,
    );
  }

  Widget topImage() {
    return Image.asset(
      "assets/profile/help-top-image.png",
      fit: BoxFit.cover,
      height: 128.0,
    );
  }
}
