import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/main.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/column_builder.dart';
import 'package:flutter/material.dart';

class LanguageScreen extends StatefulWidget {
  const LanguageScreen({super.key});

  @override
  State<LanguageScreen> createState() => _LanguageScreenState();
}

class _LanguageScreenState extends State<LanguageScreen> {
  late int selectedIndex;

  void _changeLanguges(String languageCode) async {
    Locale temp = await setLocale(languageCode);

    if (mounted) {
      MyApp.setLocale(context, temp);
    }
  }

  @override
  void initState() {
    setState(() {
      selectedIndex = languageValue!;
    });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        centerTitle: false,
        backgroundColor: whiteColor,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'languages.language'),
          style: medium18Black,
        ),
      ),
      body: languageListContent(),
      bottomNavigationBar: updateButton(context),
    );
  }

  updateButton(BuildContext context) {
    return Padding(
      padding:
          EdgeInsets.only(bottom: MediaQuery.of(context).viewInsets.bottom),
      child: GestureDetector(
        onTap: () {
          setState(() {
            languageValue = selectedIndex;
            for (int i = 0; i < Languages.languageList.length; i++) {
              if (languageValue == i) {
                _changeLanguges(
                    Languages.languageList[i].languageCode.toString());
              }
            }
          });

          setIntLanguageValue(languageValue!);
          Navigator.pop(context);
        },
        child: Container(
          width: double.maxFinite,
          margin: const EdgeInsets.symmetric(
              horizontal: fixPadding * 2.0, vertical: fixPadding * 2.5),
          padding: const EdgeInsets.symmetric(
              vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
          decoration: BoxDecoration(
            color: primaryColor,
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: buttonShadow,
          ),
          child: Text(
            tr(context, 'languages.update'),
            style: medium20White,
            textAlign: TextAlign.center,
            overflow: TextOverflow.ellipsis,
          ),
        ),
      ),
    );
  }

  languageListContent() {
    return ListView(
      physics: const BouncingScrollPhysics(),
      padding: const EdgeInsets.symmetric(vertical: fixPadding * 2.0),
      children: [
        Container(
          width: double.maxFinite,
          color: whiteColor,
          child: ColumnBuilder(
            itemBuilder: (context, index) {
              return Column(
                children: [
                  GestureDetector(
                    onTap: () {
                      setState(() {
                        selectedIndex = index;
                      });
                    },
                    child: Padding(
                      padding: const EdgeInsets.all(fixPadding * 2.0),
                      child: Row(
                        children: [
                          Expanded(
                            child: Text(
                              Languages.languageList[index].name.toString(),
                              style: regular16Black,
                            ),
                          ),
                          widthSpace,
                          Container(
                            height: 24.0,
                            width: 24.0,
                            decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              color: whiteColor,
                              border: selectedIndex == index
                                  ? Border.all(color: primaryColor, width: 8.0)
                                  : null,
                              boxShadow: selectedIndex == index
                                  ? buttonShadow
                                  : boxShadow2,
                            ),
                          )
                        ],
                      ),
                    ),
                  ),
                  Languages.languageList.length - 1 == index
                      ? const SizedBox()
                      : Container(
                          width: double.maxFinite,
                          height: 1.0,
                          color: greyD4Color,
                        )
                ],
              );
            },
            itemCount: Languages.languageList.length,
          ),
        ),
      ],
    );
  }
}

class Languages {
  String? name;
  String? languageCode;
  int? id;

  Languages({this.id, this.languageCode, this.name});

  static final languageList = [
    Languages(id: 0, name: "English", languageCode: 'en'),
    Languages(id: 1, name: "हिंदी", languageCode: 'hi'),
    Languages(id: 2, name: "தமிழ்", languageCode: 'ta'),
    Languages(id: 3, name: "తెలుగు", languageCode: 'te'),


  ];
}
