import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class PrivacyPolicyScreen extends StatefulWidget {
  const PrivacyPolicyScreen({super.key});

  @override
  State<PrivacyPolicyScreen> createState() => _PrivacyPolicyScreenState();
}

class _PrivacyPolicyScreenState extends State<PrivacyPolicyScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        centerTitle: false,
        backgroundColor: whiteColor,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'privacy_policy.privacy_policy'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        physics: const BouncingScrollPhysics(),
        padding: EdgeInsets.zero,
        children: [
          topImage(),
          privacyContent(),
        ],
      ),
    );
  }

  privacyContent() {
    return const Padding(
      padding: EdgeInsets.all(fixPadding * 2.0),
      child: Column(
        children: [
          Text(
            "The Gounder Elite Association Erode App respects and protects the privacy of all its members. This privacy policy explains how we collect, use, and safeguard your personal information when you use our mobile application. By using this app, you agree to the collection and use of information as described in this policy.",
            style: regular15Grey,
          ),
          heightSpace,
          height5Space,
          Text(
            "We may collect basic personal details such as your name, mobile number, profile photo, and other necessary information during registration and while using the app services. This information is used only for member verification, communication, event updates, and official association activities. We do not sell, rent, or share your personal data with any third party without your consent, except when required by law.",
            style: regular15Grey,
          ),
          heightSpace,
          height5Space,
          Text(
            "All user data is stored securely using industry-standard security practices. While we take strong measures to protect your information, no digital system is completely secure. The Gounder Elite Association Erode is not responsible for any data loss caused due to cyber attacks, server failures, or unauthorized third-party access beyond our control.",
            style: regular15Grey,
          ),
          heightSpace,
          height5Space,
          Text(
            "The app may use device permissions such as camera, storage, and internet access only to provide better services like profile updates, document uploads, and notifications. These permissions are used strictly for app functionality and not for any misuse. You can control app permissions anytime through your mobile settings.",
            style: regular15Grey,
          ),
          heightSpace,
          height5Space,
          Text(
            "The privacy policy may be updated from time to time based on legal, technical, or service changes. Any updates will be reflected inside the app. Continued use of the application after such updates means you accept the revised privacy policy. If you have any concerns about data usage or privacy, you may contact the Gounder Elite Association Erode support team through official channels.",
            style: regular15Grey,
          ),
        ],
      ),
    );
  }

  topImage() {
    return Image.asset(
      "assets/profile/privacy-top-image.png",
      fit: BoxFit.cover,
      height: 128.0,
    );
  }
}
