import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class TermsAndConditionScreen extends StatefulWidget {
  const TermsAndConditionScreen({super.key});

  @override
  State<TermsAndConditionScreen> createState() =>
      _TermsAndConditionScreenState();
}

class _TermsAndConditionScreenState extends State<TermsAndConditionScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        centerTitle: false,
        backgroundColor: whiteColor,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'terms_and_condition.terms_and_condition'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        padding: const EdgeInsets.all(fixPadding * 2.0),
        physics: const BouncingScrollPhysics(),
        children: const [
          Text(
            "By using the Gounder Elite Association Erode mobile application, you agree to follow all rules, policies, and usage guidelines of the association. This app is designed to connect members, share official updates, manage events, and support community activities. You must provide correct and genuine information during registration and while using any feature of the application.",
            style: regular15Grey,
          ),
          heightSpace,
          height5Space,
          Text(
            "All content available in this application, including text, images, notifications, event details, and other materials, is the property of Gounder Elite Association Erode. You are not allowed to copy, edit, reuse, or distribute any content from the app without written permission from the association. Any unauthorized use of content may result in suspension of your account or further legal action if required.",
            style: regular15Grey,
          ),
          heightSpace,
          height5Space,
          Text(
            "You are responsible for maintaining the confidentiality of your mobile number, OTP, and any login credentials used to access the app. The association will not be responsible for any loss, damage, or misuse caused due to sharing of your login details with others. If you notice any suspicious activity in your account, you must immediately inform the Gounder Elite Association Erode support team.",
            style: regular15Grey,
          ),
          heightSpace,
          height5Space,
          Text(
            "The Gounder Elite Association Erode app must be used only for lawful, respectful, and community-oriented purposes. Posting abusive messages, false information, offensive content, political promotions, or anything that disturbs peace and unity within the community is strictly prohibited. The association reserves full right to remove such content and permanently block the user without prior notice.",
            style: regular15Grey,
          ),
          heightSpace,
          height5Space,
          Text(
            "The association may update features, design, security, and terms of this application at any time without prior notice. Continued use of the app after such updates means you accept the revised terms and conditions. The association is not responsible for service interruptions, technical issues, or data loss caused by network problems or third-party services. By using this app, you confirm that you have read, understood, and agreed to these Terms and Conditions of the Gounder Elite Association Erode App.",
            style: regular15Grey,
          ),
        ],
      ),
    );
  }
}
