import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';
import 'package:iconify_flutter/iconify_flutter.dart';
import 'package:iconify_flutter/icons/carbon.dart';
import 'package:iconify_flutter/icons/healthicons.dart';

class SecurityScreen extends StatefulWidget {
  const SecurityScreen({super.key});

  @override
  State<SecurityScreen> createState() => _SecurityScreenState();
}

class _SecurityScreenState extends State<SecurityScreen> {
  final securityAlertList = [
    {"image": "assets/icons/fire-alert.png", "title": "Fire alert"},
    {"image": "assets/icons/elevator-light.png", "title": "Stuck in lift"},
    {"image": "assets/icons/animal-dog.png", "title": "Animal threat"},
    {"image": "assets/icons/anti-theft.png", "title": "Visitor threat"},
  ];

  @override
  Widget build(BuildContext context) {
    final size = MediaQuery.sizeOf(context);
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'security.security'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        shrinkWrap: true,
        physics: const BouncingScrollPhysics(),
        padding: EdgeInsets.zero,
        children: [
          topImage(),
          Padding(
            padding: const EdgeInsets.all(fixPadding * 2.0),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                title(tr(context, 'security.send_message')),
                heightSpace,
                Wrap(
                  spacing: fixPadding * 2.0,
                  runSpacing: fixPadding * 2.0,
                  children: [
                    boxWidget(size, Carbon.ibm_security,
                        tr(context, 'security.admin'), () {
                      Navigator.pushNamed(context, '/chat');
                    }),
                    boxWidget(size, Healthicons.security_worker_outline,
                        tr(context, 'security.security'), () {
                      Navigator.pushNamed(context, '/chat');
                    }),
                  ],
                ),
                heightSpace,
                heightSpace,
                title(tr(context, 'security.security_alert')),
                heightSpace,
                securityAlerts(size),
              ],
            ),
          )
        ],
      ),
    );
  }

  securityAlerts(Size size) {
    return Wrap(
      spacing: fixPadding * 2.0,
      runSpacing: fixPadding * 2.0,
      children: List.generate(
        securityAlertList.length,
        (index) {
          final securityAlertData = securityAlertList[index];
          return Container(
            padding: const EdgeInsets.symmetric(
                horizontal: fixPadding, vertical: fixPadding * 2.0),
            width: (size.width - 60) / 2,
            decoration: BoxDecoration(
              color: whiteColor,
              borderRadius: BorderRadius.circular(10.0),
            ),
            child: Column(
              children: [
                Image.asset(
                  securityAlertData['image'].toString(),
                  color: primaryColor,
                  height: 36.0,
                  fit: BoxFit.contain,
                ),
                heightSpace,
                Text(
                  securityAlertData['title'].toString(),
                  style: medium16Primary,
                  textAlign: TextAlign.center,
                  overflow: TextOverflow.ellipsis,
                )
              ],
            ),
          );
        },
      ),
    );
  }

  title(String title) {
    return Text(
      title,
      style: medium16Black,
    );
  }

  imageIconBoxWidget(Size size, String icon, String title, Function() onTap) {
    return Container(
      padding: const EdgeInsets.symmetric(
          horizontal: fixPadding, vertical: fixPadding * 2.0),
      width: (size.width - 60) / 2,
      decoration: BoxDecoration(
        color: whiteColor,
        borderRadius: BorderRadius.circular(10.0),
      ),
      child: Column(
        children: [
          Image.asset(
            icon,
            color: primaryColor,
            height: 36.0,
            fit: BoxFit.contain,
          ),
          heightSpace,
          Text(
            title,
            style: medium16Primary,
            textAlign: TextAlign.center,
            overflow: TextOverflow.ellipsis,
          )
        ],
      ),
    );
  }

  boxWidget(Size size, String icon, String title, Function() onTap) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        padding: const EdgeInsets.symmetric(
            horizontal: fixPadding, vertical: fixPadding * 2.0),
        width: (size.width - 60) / 2,
        decoration: BoxDecoration(
          color: whiteColor,
          borderRadius: BorderRadius.circular(10.0),
        ),
        child: Column(
          children: [
            Iconify(
              icon,
              color: primaryColor,
              size: 36.0,
            ),
            heightSpace,
            Text(
              title,
              style: medium16Primary,
              textAlign: TextAlign.center,
              overflow: TextOverflow.ellipsis,
            )
          ],
        ),
      ),
    );
  }

  topImage() {
    return Image.asset(
      "assets/community/security-top-image.png",
      height: 128.0,
      width: double.maxFinite,
      fit: BoxFit.cover,
    );
  }
}
