import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/column_builder.dart';
import 'package:flutter/material.dart';

class SelectPaymentScreen extends StatefulWidget {
  const SelectPaymentScreen({super.key});

  @override
  State<SelectPaymentScreen> createState() => _SelectPaymentScreenState();
}

class _SelectPaymentScreenState extends State<SelectPaymentScreen> {
  final paymentMethodList = [
    {"image": "assets/payment/credit-card.png", "title": "Credit card"},
    {"image": "assets/payment/paypal.png", "title": "Paypal"},
    {"image": "assets/payment/google-pay.png", "title": "Google pay"},
    {"image": "assets/payment/wallet.png", "title": "Use wallet"},
    {"image": "assets/payment/money.png", "title": "Pay cash to admin"},
  ];
  int selectedIndex = 0;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: false,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'select_payment.select_payment'),
          style: medium18Black,
        ),
      ),
      body: ListView(
        padding: const EdgeInsets.symmetric(vertical: fixPadding * 2.0),
        physics: const BouncingScrollPhysics(),
        children: [
          amountDetail(),
          heightSpace,
          heightSpace,
          paymentMethodListContent(),
        ],
      ),
      bottomNavigationBar: makePaymentButton(),
    );
  }

  makePaymentButton() {
    return GestureDetector(
      onTap: () {
        Navigator.pushNamed(context, '/creditcard');
      },
      child: Container(
        padding: const EdgeInsets.symmetric(
            vertical: fixPadding * 1.1, horizontal: fixPadding * 2.0),
        margin: const EdgeInsets.symmetric(
            vertical: fixPadding * 2.5, horizontal: fixPadding * 2.0),
        decoration: BoxDecoration(
          color: primaryColor,
          borderRadius: BorderRadius.circular(10.0),
          boxShadow: buttonShadow,
        ),
        child: Text(
          tr(context, 'select_payment.make_payment'),
          style: medium20White,
          textAlign: TextAlign.center,
          overflow: TextOverflow.ellipsis,
        ),
      ),
    );
  }

  paymentMethodListContent() {
    return Container(
      padding: const EdgeInsets.symmetric(vertical: fixPadding / 2),
      width: double.maxFinite,
      color: whiteColor,
      child: ColumnBuilder(
        itemBuilder: (context, index) {
          final itemData = paymentMethodList[index];
          return Column(
            children: [
              InkWell(
                onTap: () {
                  setState(() {
                    selectedIndex = index;
                  });
                },
                child: Padding(
                  padding: const EdgeInsets.symmetric(
                      horizontal: fixPadding * 2.0, vertical: fixPadding * 1.5),
                  child: Row(
                    children: [
                      Image.asset(
                        itemData['image'].toString(),
                        height: 34.0,
                        width: 40.0,
                        fit: BoxFit.contain,
                      ),
                      widthSpace,
                      width5Space,
                      Expanded(
                        child: Text(
                          itemData['title'].toString(),
                          style: regular16Black,
                        ),
                      ),
                      widthSpace,
                      selectedIndex == index
                          ? Container(
                              width: 21.0,
                              height: 21.0,
                              decoration: BoxDecoration(
                                shape: BoxShape.circle,
                                color: whiteColor,
                                boxShadow: buttonShadow,
                                border:
                                    Border.all(color: primaryColor, width: 7.0),
                              ),
                            )
                          : Container(
                              width: 21.0,
                              height: 21.0,
                              decoration: BoxDecoration(
                                shape: BoxShape.circle,
                                color: whiteColor,
                                boxShadow: boxShadow2,
                              ),
                            )
                    ],
                  ),
                ),
              ),
              index == paymentMethodList.length - 1
                  ? const SizedBox()
                  : Container(
                      width: double.maxFinite,
                      height: 1.0,
                      color: greyD4Color,
                    ),
            ],
          );
        },
        itemCount: paymentMethodList.length,
      ),
    );
  }

  amountDetail() {
    return Container(
      color: whiteColor,
      padding: const EdgeInsets.symmetric(
          horizontal: fixPadding * 2.0, vertical: fixPadding * 1.5),
      width: double.maxFinite,
      child: const Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            "Maintenance Feb 2024",
            style: medium16Primary,
          ),
          heightSpace,
          Text(
            "\$20.00",
            style: regular16Black,
          )
        ],
      ),
    );
  }
}
