import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:flutter/material.dart';

class ServiceScreen extends StatefulWidget {
  const ServiceScreen({super.key});

  @override
  State<ServiceScreen> createState() => _ServiceScreenState();
}

class _ServiceScreenState extends State<ServiceScreen> {
  final servicesList = [
    {
      "image": "assets/services/home-cleaner.png",
      "title": "Home cleaning",
      "color": const Color(0xFFDA64A6),
      "bgColor": const Color(0xFFFDE5F7)
    },
    {
      "image": "assets/services/carpenter.png",
      "title": "Carpenter service",
      "color": const Color(0xFFDEB15D),
      "bgColor": const Color(0xFFFEF0D2)
    },
    {
      "image": "assets/services/repair.png",
      "title": "Appliances repair",
      "color": const Color(0xFF7185C7),
      "bgColor": const Color(0xFFDFE6F5)
    },
    {
      "image": "assets/services/electrician.png",
      "title": "Electrician",
      "color": const Color(0xFFC57EDB),
      "bgColor": const Color(0xFFFAD6FE)
    },
    {
      "image": "assets/services/plumbing.png",
      "title": "Plumbing",
      "color": const Color(0xFF4AB67A),
      "bgColor": const Color(0xFFD7F2E3)
    },
    {
      "image": "assets/services/packer-mover.png",
      "title": "Packer & mover",
      "color": const Color(0xFFDF904A),
      "bgColor": const Color(0xFFFFE7D7)
    },
    {
      "image": "assets/services/home-sanitize.png",
      "title": "Home sanitize",
      "color": const Color(0xFF438BCF),
      "bgColor": const Color(0xFFD8E9FD)
    },
    {
      "image": "assets/services/hair-beauty.png",
      "title": "Hair & beauty",
      "color": const Color(0xFFEE6E66),
      "bgColor": const Color(0xFFFFDAD8)
    },
    {
      "image": "assets/services/cooking.png",
      "title": "Cooking",
      "color": const Color(0xFFDA64A6),
      "bgColor": const Color(0xFFFDE5F7)
    },
    {
      "image": "assets/services/security.png",
      "title": "Security",
      "color": const Color(0xFFDF904A),
      "bgColor": const Color(0xFFFFE7D7)
    },
    {
      "image": "assets/services/laundry-service.png",
      "title": "Laundry service",
      "color": const Color(0xFF788DC9),
      "bgColor": const Color(0xFFDFE6F5)
    },
    {
      "image": "assets/services/garding.png",
      "title": "Gardening",
      "color": const Color(0xFFC57EDB),
      "bgColor": const Color(0xFFFAD6FE)
    },
  ];

  @override
  Widget build(BuildContext context) {
    final size = MediaQuery.sizeOf(context);
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: whiteColor,
        centerTitle: true,
        titleSpacing: 20.0,
        title: Text(
          tr(context, 'service.service'),
          style: medium20Primary,
        ),
      ),
      body: servicesListContent(size),
    );
  }

  servicesListContent(Size size) {
    return ListView(
      padding: const EdgeInsets.all(fixPadding * 2.0),
      physics: const BouncingScrollPhysics(),
      children: [
        Wrap(
          spacing: fixPadding * 2.0,
          runSpacing: fixPadding * 2.0,
          children: List.generate(
            servicesList.length,
            (index) {
              final serviceItemData = servicesList[index];
              return GestureDetector(
                onTap: () {
                  Navigator.pushNamed(context, '/bookService');
                },
                child: Container(
                  padding: const EdgeInsets.symmetric(
                      horizontal: fixPadding, vertical: fixPadding * 1.5),
                  width: (size.width - 60) / 2,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10.0),
                    boxShadow: boxShadow,
                    color: whiteColor,
                  ),
                  child: Column(
                    children: [
                      Container(
                        height: 55.0,
                        width: 55.0,
                        decoration: BoxDecoration(
                          shape: BoxShape.circle,
                          color: serviceItemData['bgColor'] as Color,
                        ),
                        alignment: Alignment.center,
                        child: Image.asset(
                          serviceItemData['image'].toString(),
                          height: 36.0,
                          color: serviceItemData['color'] as Color,
                          fit: BoxFit.contain,
                        ),
                      ),
                      height5Space,
                      Text(
                        serviceItemData['title'].toString(),
                        style: regular16Black,
                        overflow: TextOverflow.ellipsis,
                      )
                    ],
                  ),
                ),
              );
            },
          ),
        )
      ],
    );
  }
}
