import 'package:fl_ks_smart_society_user/localization/localization_const.dart';
import 'package:fl_ks_smart_society_user/theme/theme.dart';
import 'package:fl_ks_smart_society_user/widget/column_builder.dart';
import 'package:flutter/material.dart';
import 'package:iconify_flutter/iconify_flutter.dart';
import 'package:iconify_flutter/icons/material_symbols.dart';
import 'package:iconify_flutter/icons/ri.dart';

class VisitorsScreen extends StatefulWidget {
  const VisitorsScreen({super.key});

  @override
  State<VisitorsScreen> createState() => _VisitorsScreenState();
}

class _VisitorsScreenState extends State<VisitorsScreen> {
  final visitorsList = [
    {
      "image": "assets/members/member-1.png",
      "type": "Inside",
      "title": "Maid- jenny wilsom",
      "dateTime": "22 aug 2022 at 9:30 AM"
    },
    {
      "image": "assets/members/member-14.png",
      "type": "Pre approved",
      "title": "Guest - jenny wilsom",
      "dateTime": "22 aug 2022 at 9:30 AM"
    },
    {
      "image": "assets/members/member-8.png",
      "type": "Pre approved",
      "title": "Cab booking - Uber 2024",
      "dateTime": "22 aug 2022 at 8:30 AM"
    },
    {
      "image": "assets/members/member-7.png",
      "type": "Service booked",
      "title": "Appliances repair",
      "dateTime": "22 aug 2022 at 3:30 PM"
    },
    {
      "image": "assets/members/member-10.png",
      "type": "Service booked",
      "title": "Appliances repair",
      "dateTime": "22 aug 2022 at 3:30 PM"
    },
  ];

  @override
  Widget build(BuildContext context) {
    final size = MediaQuery.of(context).size;
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        centerTitle: false,
        backgroundColor: whiteColor,
        titleSpacing: 0.0,
        leading: IconButton(
          onPressed: () {
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back,
            color: blackColor,
          ),
        ),
        title: Text(
          tr(context, 'visitors.visitors'),
          style: medium18Black,
        ),
      ),
      body: visitorsList.isEmpty
          ? emptyListContent()
          : ListView(
              physics: const BouncingScrollPhysics(),
              padding: EdgeInsets.zero,
              children: [
                topImage(),
                visitorsListContent(size),
              ],
            ),
    );
  }

  emptyListContent() {
    return Center(
      child: ListView(
        shrinkWrap: true,
        padding: const EdgeInsets.all(fixPadding * 2.0),
        physics: const BouncingScrollPhysics(),
        children: [
          Image.asset(
            "assets/icons/shield-user.png",
            height: 40.0,
            color: greyColor,
          ),
          heightSpace,
          Text(
            tr(context, 'visitors.no_visitors_yet'),
            style: medium16Grey,
            textAlign: TextAlign.center,
          ),
          heightSpace,
          heightSpace,
          heightSpace,
        ],
      ),
    );
  }

  visitorsListContent(Size size) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: fixPadding * 1.25),
      child: ColumnBuilder(
        itemBuilder: (context, index) {
          final itemData = visitorsList[index];

          final String visitorType = itemData['type'].toString();

          return Container(
            margin: const EdgeInsets.symmetric(vertical: fixPadding * 0.75),
            width: double.maxFinite,
            color: whiteColor,
            child: Column(
              children: [
                Padding(
                  padding: const EdgeInsets.symmetric(
                      horizontal: fixPadding * 2.0, vertical: fixPadding * 1.5),
                  child: Row(
                    children: [
                      Container(
                        height: 60.0,
                        width: 60.0,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(5.0),
                          image: DecorationImage(
                            image: AssetImage(
                              visitorsList[index]['image'].toString(),
                            ),
                            fit: BoxFit.cover,
                          ),
                        ),
                      ),
                      widthSpace,
                      width5Space,
                      Expanded(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            if (visitorType == "Service booked")
                              Text(
                                tr(context, 'visitors.service_booked'),
                                style: regular16Primary.copyWith(
                                  color: greenColor,
                                ),
                                overflow: TextOverflow.ellipsis,
                              ),
                            if (visitorType == "Pre approved")
                              Text(
                                tr(context, 'visitors.pre_approved'),
                                style: regular16Primary.copyWith(
                                  color: const Color(0xFF2893C0),
                                ),
                                overflow: TextOverflow.ellipsis,
                              ),
                            if (visitorType == "Inside")
                              Text(
                                tr(context, 'visitors.inside'),
                                style: regular16Primary,
                                overflow: TextOverflow.ellipsis,
                              ),
                            Text(
                              itemData['title'].toString(),
                              style: regular16Black,
                              overflow: TextOverflow.ellipsis,
                            ),
                            Text(
                              itemData['dateTime'].toString(),
                              style: regular15Grey,
                              overflow: TextOverflow.ellipsis,
                            )
                          ],
                        ),
                      )
                    ],
                  ),
                ),
                divider(),
                Padding(
                  padding: const EdgeInsets.symmetric(
                      horizontal: fixPadding * 2.0, vertical: fixPadding * 1.5),
                  child: Row(
                    children: [
                      Expanded(
                        child: InkWell(
                          onTap: () {
                            Navigator.pushNamed(context, '/call');
                          },
                          child: Row(
                            children: [
                              const Icon(
                                Icons.call_outlined,
                                color: greenColor,
                                size: 16.0,
                              ),
                              width5Space,
                              ConstrainedBox(
                                constraints: BoxConstraints(
                                    maxWidth: (size.width - 125) / 3),
                                child: const Text(
                                  "Call",
                                  style: regular14Green,
                                  overflow: TextOverflow.ellipsis,
                                ),
                              )
                            ],
                          ),
                        ),
                      ),
                      widthSpace,
                      Expanded(
                        child: InkWell(
                          onTap: () {
                            setState(() {
                              visitorsList.removeAt(index);
                            });
                            ScaffoldMessenger.of(context).showSnackBar(
                              SnackBar(
                                backgroundColor: originalBlackColor,
                                behavior: SnackBarBehavior.floating,
                                duration: const Duration(milliseconds: 1500),
                                content: Text(
                                  tr(context, 'visitors.removed_from_visitors'),
                                  style: medium15White,
                                ),
                              ),
                            );
                          },
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              const Iconify(
                                MaterialSymbols.delete_outline,
                                color: greyColor,
                                size: 16.0,
                              ),
                              width5Space,
                              ConstrainedBox(
                                constraints: BoxConstraints(
                                    maxWidth: (size.width - 125) / 3),
                                child: Text(
                                  tr(context, 'visitors.delete'),
                                  style: regular14Grey,
                                  overflow: TextOverflow.ellipsis,
                                ),
                              )
                            ],
                          ),
                        ),
                      ),
                      widthSpace,
                      Expanded(
                        child: GestureDetector(
                          onTap: () {
                            Navigator.pushNamed(context, '/gatePass');
                          },
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.end,
                            children: [
                              const Iconify(
                                Ri.passport_line,
                                color: greyColor,
                                size: 16.0,
                              ),
                              width5Space,
                              ConstrainedBox(
                                constraints: BoxConstraints(
                                    maxWidth: (size.width - 125) / 3),
                                child: Text(
                                  tr(context, 'visitors.get_pass'),
                                  style: regular14Grey,
                                  overflow: TextOverflow.ellipsis,
                                ),
                              )
                            ],
                          ),
                        ),
                      )
                    ],
                  ),
                )
              ],
            ),
          );
        },
        itemCount: visitorsList.length,
      ),
    );
  }

  Widget topImage() {
    return Image.asset(
      "assets/community/visitor-top-image.png",
      fit: BoxFit.cover,
      height: 128,
      width: double.maxFinite,
    );
  }

  divider() {
    return Container(
      width: double.maxFinite,
      height: 1.0,
      color: greyD4Color,
    );
  }
}
