import 'package:flutter/material.dart';

const Color primaryColor = Color(0xFFF0D9412);
const Color screenBgColor = Color(0xFFF5F5F5);
const Color whiteColor = Colors.white;
const Color originalBlackColor = Colors.black;
const Color greyColor = Color(0xFF949494);
const Color blackColor = Color(0xFF333333);
const Color greyB4Color = Color(0xFFB4B4B4);
const Color greyD4Color = Color(0xFFD4D4D4);
const Color recColor = Color(0xFFFFF3EE);
const Color redColor = Color(0xFFD21111);
const Color lightRedColor = Color(0xFFF24444);
const Color greenColor = Color(0xFF0D9412);
const Color darkBlueColor = Color(0xFF1E4799);

const double fixPadding = 10.0;

const SizedBox heightSpace = SizedBox(height: fixPadding);
const SizedBox height5Space = SizedBox(height: 5.0);
const SizedBox widthSpace = SizedBox(width: fixPadding);
const SizedBox width5Space = SizedBox(width: 5.0);

SizedBox widthBox(double width) => SizedBox(width: width);
SizedBox heightBox(double height) => SizedBox(height: height);

List<BoxShadow> buttonShadow = [
  BoxShadow(
    color: const Color(0xFFDF8C6E).withOpacity(0.15),
    blurRadius: 12.0,
    offset: const Offset(0, 6),
  )
];

List<BoxShadow> boxShadow = [
  BoxShadow(
    color: originalBlackColor.withOpacity(0.25),
    blurRadius: 6.0,
  ),
];
List<BoxShadow> boxShadow2 = [
  BoxShadow(
    color: originalBlackColor.withOpacity(0.2),
    blurRadius: 6.0,
  ),
];

OutlineInputBorder focusedBorder = OutlineInputBorder(
  borderRadius: BorderRadius.circular(10.0),
  borderSide: const BorderSide(color: primaryColor),
);

const TextStyle semibold22White =
    TextStyle(color: whiteColor, fontSize: 22.0, fontWeight: FontWeight.w600);

const TextStyle semibold16White =
    TextStyle(color: whiteColor, fontSize: 16.0, fontWeight: FontWeight.w600);

const TextStyle semibold14White =
    TextStyle(color: whiteColor, fontSize: 14.0, fontWeight: FontWeight.w600);

const TextStyle medium20Primary =
    TextStyle(color: primaryColor, fontSize: 20.0, fontWeight: FontWeight.w500);

const TextStyle medium18Primary =
    TextStyle(color: primaryColor, fontSize: 18.0, fontWeight: FontWeight.w500);

const TextStyle medium17Primary =
    TextStyle(color: primaryColor, fontSize: 17.0, fontWeight: FontWeight.w500);

const TextStyle medium16Primary =
    TextStyle(color: primaryColor, fontSize: 16.0, fontWeight: FontWeight.w500);

const TextStyle medium20White =
    TextStyle(color: whiteColor, fontSize: 20.0, fontWeight: FontWeight.w500);

const TextStyle medium18White =
    TextStyle(color: whiteColor, fontSize: 18.0, fontWeight: FontWeight.w500);

const TextStyle medium17White =
    TextStyle(color: whiteColor, fontSize: 17.0, fontWeight: FontWeight.w500);

const TextStyle medium16White =
    TextStyle(color: whiteColor, fontSize: 16.0, fontWeight: FontWeight.w500);

const TextStyle regular14White =
TextStyle(color: whiteColor, fontSize: 14.0, fontWeight: FontWeight.w400);

const TextStyle medium15White =
    TextStyle(color: whiteColor, fontSize: 15.0, fontWeight: FontWeight.w500);

const TextStyle medium18Black =
    TextStyle(color: blackColor, fontSize: 18.0, fontWeight: FontWeight.w500);

const TextStyle medium17Black =
    TextStyle(color: blackColor, fontSize: 17.0, fontWeight: FontWeight.w500);

const TextStyle medium16Black =
    TextStyle(color: blackColor, fontSize: 16.0, fontWeight: FontWeight.w500);

const TextStyle medium15Black =
    TextStyle(color: blackColor, fontSize: 15.0, fontWeight: FontWeight.w500);

const TextStyle medium16GreyB4 =
    TextStyle(color: greyB4Color, fontSize: 16.0, fontWeight: FontWeight.w500);

const TextStyle medium18Grey =
    TextStyle(color: greyColor, fontSize: 18.0, fontWeight: FontWeight.w500);

const TextStyle medium16Grey =
    TextStyle(color: greyColor, fontSize: 16.0, fontWeight: FontWeight.w500);

const TextStyle medium16Green =
    TextStyle(color: greenColor, fontSize: 16.0, fontWeight: FontWeight.w500);

const TextStyle regular17Primary =
    TextStyle(color: primaryColor, fontSize: 17.0, fontWeight: FontWeight.w400);

const TextStyle regular16Primary =
    TextStyle(color: primaryColor, fontSize: 16.0, fontWeight: FontWeight.w400);

const TextStyle regular15Primary =
    TextStyle(color: primaryColor, fontSize: 15.0, fontWeight: FontWeight.w400);

const TextStyle regular14Primary =
    TextStyle(color: primaryColor, fontSize: 14.0, fontWeight: FontWeight.w400);

const TextStyle regular45White =
    TextStyle(color: whiteColor, fontSize: 45.0, fontWeight: FontWeight.w400);

const TextStyle regular16White =
    TextStyle(color: whiteColor, fontSize: 16.0, fontWeight: FontWeight.w400);

const TextStyle regular15White =
    TextStyle(color: whiteColor, fontSize: 15.0, fontWeight: FontWeight.w400);

const TextStyle regular18Black =
    TextStyle(color: blackColor, fontSize: 18.0, fontWeight: FontWeight.w400);

const TextStyle regular17Black =
    TextStyle(color: blackColor, fontSize: 17.0, fontWeight: FontWeight.w400);

const TextStyle regular16Black =
    TextStyle(color: blackColor, fontSize: 16.0, fontWeight: FontWeight.w400);

const TextStyle regular15Black =
    TextStyle(color: blackColor, fontSize: 15.0, fontWeight: FontWeight.w400);

const TextStyle regular14Black =
    TextStyle(color: blackColor, fontSize: 14.0, fontWeight: FontWeight.w400);

const TextStyle regular20Grey =
    TextStyle(color: greyColor, fontSize: 20.0, fontWeight: FontWeight.w400);

const TextStyle regular18Grey =
    TextStyle(color: greyColor, fontSize: 18.0, fontWeight: FontWeight.w400);

const TextStyle regular17Grey =
    TextStyle(color: greyColor, fontSize: 17.0, fontWeight: FontWeight.w400);

const TextStyle regular16Grey =
    TextStyle(color: greyColor, fontSize: 16.0, fontWeight: FontWeight.w400);

const TextStyle regular15Grey =
    TextStyle(color: greyColor, fontSize: 15.0, fontWeight: FontWeight.w400);

const TextStyle regular14Grey =
    TextStyle(color: greyColor, fontSize: 14.0, fontWeight: FontWeight.w400);

const TextStyle regular12Grey =
    TextStyle(color: greyColor, fontSize: 12.0, fontWeight: FontWeight.w400);

const TextStyle regular16Green =
    TextStyle(color: greenColor, fontSize: 16.0, fontWeight: FontWeight.w400);

const TextStyle regular14Green =
    TextStyle(color: greenColor, fontSize: 14.0, fontWeight: FontWeight.w400);

const TextStyle regular16Red =
    TextStyle(color: redColor, fontSize: 16.0, fontWeight: FontWeight.w400);
