import 'package:flutter/material.dart';
import 'package:fl_sevengen_society_user_app/localization/localization_const.dart';
import 'package:fl_sevengen_society_user_app/theme/theme.dart';

class ServiceScreen extends StatefulWidget {
  const ServiceScreen({super.key});

  @override
  State<ServiceScreen> createState() => _ServiceScreenState();
}

class _ServiceScreenState extends State<ServiceScreen> {
  // Service list
  final serviceList = [
    {
      "image": "assets/services/cleaning.png",
      "name": "Lead form",
      "route": "/lead"
    },
    {
      "image": "assets/services/mechanic.png",
      "name": "Feedback form",
      "route": "/feedback-app"
    },
    {
      "image": "assets/services/carpenter.png",
      "name": "Specific Ask",
      "route": "/SpecificAskForm"
    },
    {
      "image": "assets/services/painter.png",
      "name": "Specific List",
      "route": "/SpecificAskList"
    },
    {
      "image": "assets/services/technician.png",
      "name": "Referral to R",
      "route": "/referral-to-referral"
    },
    {
      "image": "assets/services/shipping.png",
      "name": "Notifications",
      "route": "/notifications"
    },
  ];

  @override
  Widget build(BuildContext context) {
    final size = MediaQuery.of(context).size;

    return Scaffold(
      appBar: AppBar(
        backgroundColor: whiteColor,
        elevation: 0.0,
        titleSpacing: 0.0,
        centerTitle: false,
        automaticallyImplyLeading: false,
        leading: IconButton(
          icon: const Icon(Icons.arrow_back),
          color: blackColor,
          onPressed: () {
            // Go to bottom bar screen
            Navigator.pushNamedAndRemoveUntil(
              context,
              '/bottomBar',
                  (route) => false,
            );
          },
        ),
        title: Text(
          getTranslate(context, 'service.service'),
          style: semibold22Black33,
        ),
      ),
      body: ListView(
        padding: const EdgeInsets.only(
          top: fixPadding,
          bottom: fixPadding * 9.0,
        ),
        physics: const BouncingScrollPhysics(),
        children: [
          nearByServiceListContent(size),
        ],
      ),
    );
  }

  Widget nearByServiceListContent(Size size) {
    return Container(
      color: f6f3Color,
      width: double.maxFinite,
      child: GridView.builder(
        shrinkWrap: true,
        physics: const NeverScrollableScrollPhysics(),
        padding: const EdgeInsets.all(fixPadding * 2.0),
        gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 2,
          mainAxisSpacing: fixPadding * 2.0,
          crossAxisSpacing: fixPadding * 2.0,
          childAspectRatio: 1.7,
        ),
        itemCount: serviceList.length,
        itemBuilder: (context, index) {
          final item = serviceList[index];

          return GestureDetector(
            onTap: () {
              final routeName = item['route']?.toString() ?? '';

              if (routeName.isNotEmpty) {
                Navigator.pushNamed(
                  context,
                  routeName,
                  arguments: {
                    'service_route': routeName,
                    'service_name': item['name'],
                  },
                );
              } else {
                ScaffoldMessenger.of(context).showSnackBar(
                  SnackBar(
                    content: Text(item['name'].toString()),
                  ),
                );
              }
            },
            child: Container(
              decoration: BoxDecoration(
                color: whiteColor,
                borderRadius: BorderRadius.circular(10.0),
                boxShadow: [
                  BoxShadow(
                    color: blackColor.withOpacity(0.1),
                    blurRadius: 12.0,
                    offset: const Offset(0, 6),
                  ),
                ],
              ),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Image.asset(
                    item['image'].toString(),
                    height: 35.0,
                    width: 35.0,
                  ),
                  heightSpace,
                  Text(
                    item['name'].toString(),
                    style: medium15Primary,
                    overflow: TextOverflow.ellipsis,
                  ),
                ],
              ),
            ),
          );
        },
      ),
    );
  }
}
