// lib/screens/splash_screen.dart

import 'dart:async';
import 'package:flutter/material.dart';

class SplashScreen extends StatefulWidget {
  const SplashScreen({super.key});

  @override
  State<SplashScreen> createState() => _SplashScreenState();
}

class _SplashScreenState extends State<SplashScreen> {
  // Duration of splash screen
  static const Duration splashDuration = Duration(seconds: 3);

  @override
  void initState() {
    super.initState();
    _startSplash();
  }

  Future<void> _startSplash() async {
    // Wait for splash duration then navigate to bottom bar
    await Future.delayed(splashDuration);

    if (!mounted) return;

    Navigator.pushReplacementNamed(context, '/bottomBar');
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: SizedBox.expand(
        child: Image.asset(
          "assets/auth/bg_home.png",
          fit: BoxFit.cover,
        ),
      ),
    );
  }
}
