import 'package:flutter/material.dart';
import 'dart:convert';
import 'package:http/http.dart' as http;
import 'package:fl_sevengen_society_user_app/api_constants.dart';

class CancelReferralScreen extends StatelessWidget {
  final int referralId;

  const CancelReferralScreen({super.key, required this.referralId});

  @override
  Widget build(BuildContext context) {
    final TextEditingController reasonController = TextEditingController();

    return Scaffold(
      appBar: AppBar(title: const Text("Cancelling Referral")),
      body: Padding(
        padding: const EdgeInsets.all(16),
        child: Column(
          children: [
            TextField(
              controller: reasonController,
              maxLines: 5,
              decoration: const InputDecoration(
                labelText: "Reason",
                border: OutlineInputBorder(),
              ),
            ),
            const SizedBox(height: 20),
            ElevatedButton(
              onPressed: () async {
                await http.post(
                  Uri.parse("$apiBaseUrl/referral_cancel.php"),
                  headers: {"Content-Type": "application/json"},
                  body: jsonEncode({
                    "id": referralId,
                    "reason": reasonController.text,
                  }),
                );

                Navigator.pop(context, true);
              },
              child: const Text("Save"),
            ),
          ],
        ),
      ),
    );
  }
}
